package com.ejianc.business.datalake.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.datalake.service.IMysteelService;
import com.ejianc.business.datalake.vo.BrandRefVO;
import com.ejianc.business.datalake.vo.MarketPriceVO;
import com.ejianc.business.datalake.vo.RegionRefVO;
import com.ejianc.framework.core.response.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * [我的钢铁网] 价格查询
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("mysteel")
public class MysteelController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMysteelService service;

    /**
     * @Description getRegionRef1 地区参照
     */
    @RequestMapping(value = "/getRegionRef1", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RegionRefVO>> getRegionRef1(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText
    ) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("region");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        String materialName = null;
        String checkDate = null;

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("materialName")) {
                materialName = conditionMap.get("materialName").toString();
            }
            if(null != conditionMap.get("checkDate")) {
                checkDate = conditionMap.get("checkDate").toString();
            }
        }
        Page<RegionRefVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
    	return CommonResponse.success("保存或修改单据成功！",service.getRegionRef1(page, wrapper, materialName, checkDate));
    }

    /**
     * @Description getBrandRef1 品牌参照
     */
    @RequestMapping(value = "/getBrandRef1", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BrandRefVO>> getBrandRef1(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText
    ) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("brand");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        String materialName = null;
        String region = null;
        String checkDate = null;

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("materialName")) {
                materialName = conditionMap.get("materialName").toString();
            }
            if(null != conditionMap.get("region")) {
                region = conditionMap.get("region").toString();
            }
            if(null != conditionMap.get("checkDate")) {
                checkDate = conditionMap.get("checkDate").toString();
            }
        }
        Page<BrandRefVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
    	return CommonResponse.success("保存或修改单据成功！",service.getBrandRef1(page, wrapper, materialName, region, checkDate));
    }

    /**
     * @Description getRecomPrice1 推荐价格
     */
    @RequestMapping(value = "/getRecomPrice1", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> getRecomPrice1(
            @RequestParam(value = "region") String region,
            @RequestParam(value = "brand") String brand,
            @RequestParam(value = "materialName") String materialName,
            @RequestParam(value = "checkDate") String checkDate
    ) {
    	return CommonResponse.success("保存或修改单据成功！",service.getRecomPrice1(region, brand, materialName, checkDate));
    }

    /**
     * @Description getMarketPrice1 根据网站、地区、品牌，联查出市场价格
     */
    @RequestMapping(value = "/getMarketPrice1", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MarketPriceVO>> getMarketPrice1(
            @RequestParam(value = "region") String region,
            @RequestParam(value = "brand") String brand,
            @RequestParam(value = "materialName") String materialName,
            @RequestParam(value = "checkDate") String checkDate
    ) {
    	return CommonResponse.success("保存或修改单据成功！",service.getMarketPrice1(region, brand, materialName, checkDate));
    }

}
