package com.ejianc.business.ecxj.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 比选报价物资明细实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_compare_product")
public class CompareProductEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="compare_id")
    private Long compareId; // 比选报价单据主表主键ID
    @TableField(value="product_name")
    private String productName; // 商品名称
    @TableField(value="product_spec")
    private String productSpec; // 规格型号
    @TableField(value="product_unit")
    private String productUnit; // 计量单位
    @TableField(value="tender_num")
    private BigDecimal tenderNum; // 招标数量

    @TableField(exist = false)
    @SubEntity(serviceName = "compareSupplierService",pidName = "productId")
    private List<CompareSupplierEntity> compareSupplierEntities = new ArrayList<>(); // 比价物资中的供应商清单实体



    public Long getCompareId() {
        return compareId;
    }

    public void setCompareId(Long compareId) {
        this.compareId = compareId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getProductSpec() {
        return productSpec;
    }

    public void setProductSpec(String productSpec) {
        this.productSpec = productSpec;
    }
    public String getProductUnit() {
        return productUnit;
    }

    public void setProductUnit(String productUnit) {
        this.productUnit = productUnit;
    }
    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }

    public List<CompareSupplierEntity> getCompareSupplierEntities() {
        return compareSupplierEntities;
    }

    public void setCompareSupplierEntities(List<CompareSupplierEntity> compareSupplierEntities) {
        this.compareSupplierEntities = compareSupplierEntities;
    }
}
