package com.ejianc.business.ecxj.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 比选通知商品实体（明细）
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_notice_product")
public class NoticeProductEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="notice_id")
    private Long noticeId; // 比选通知单据主表主键ID
    @TableField(value="tender_product_id")
    private Long tenderProductId; // 云筑商品Id
    @TableField(value="product_name")
    private String productName; // 商品名称
    @TableField(value="product_spec")
    private String productSpec; // 规格型号
    @TableField(value="product_unit")
    private String productUnit; // 计量单位
    @TableField(value="tender_num")
    private BigDecimal tenderNum; // 招标数量

    @TableField(exist = false)
    @SubEntity(serviceName = "noticeSupplierService",pidName = "productId")
    private List<NoticeSupplierEntity> noticeSupplierEntities = new ArrayList<>(); // 物资中的供应商清单实体



    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    public Long getTenderProductId() {
        return tenderProductId;
    }

    public void setTenderProductId(Long tenderProductId) {
        this.tenderProductId = tenderProductId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getProductSpec() {
        return productSpec;
    }

    public void setProductSpec(String productSpec) {
        this.productSpec = productSpec;
    }
    public String getProductUnit() {
        return productUnit;
    }

    public void setProductUnit(String productUnit) {
        this.productUnit = productUnit;
    }
    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }

    public List<NoticeSupplierEntity> getNoticeSupplierEntities() {
        return noticeSupplierEntities;
    }

    public void setNoticeSupplierEntities(List<NoticeSupplierEntity> noticeSupplierEntities) {
        this.noticeSupplierEntities = noticeSupplierEntities;
    }
}
