package com.ejianc.business.ecxj.bean;

import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 集采类型设置
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_type_setting")
public class TypeSettingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资Id
    @TableField(value="material_type_name")
    private String materialTypeName; // 集采材料类型
    @TableField(value="tender_level")
    private Integer tenderLevel; // 招标层级
    @TableField(value="tender_code")
    private String tenderCode; // 招标编码
    @TableField(value="tender_name")
    private String tenderName; // 招标名称
    @TableField(value="quote_type")
    private Integer quoteType; // 报价方式
    @TableField(value="setting_status")
    private Integer settingStatus; // 集采类型状态
    @TableField(value="is_used")
    private Integer isUsed; // 是否被引用 0-未引用 1-引用
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(exist=false)
    @SubEntity(serviceName="settingProductInfoService",pidName = "settingId")
    private List<SettingProductInfoEntity> settingProductInfoEntities = new ArrayList<>(); // 设置物资清单实体



    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Integer getTenderLevel() {
        return tenderLevel;
    }

    public void setTenderLevel(Integer tenderLevel) {
        this.tenderLevel = tenderLevel;
    }
    public String getTenderCode() {
        return tenderCode;
    }

    public void setTenderCode(String tenderCode) {
        this.tenderCode = tenderCode;
    }
    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    public Integer getQuoteType() {
        return quoteType;
    }

    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }
    public Integer getSettingStatus() {
        return settingStatus;
    }

    public void setSettingStatus(Integer settingStatus) {
        this.settingStatus = settingStatus;
    }

    public Integer getIsUsed() {
        return isUsed;
    }

    public void setIsUsed(Integer isUsed) {
        this.isUsed = isUsed;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<SettingProductInfoEntity> getSettingProductInfoEntities() {
        return settingProductInfoEntities;
    }

    public void setSettingProductInfoEntities(List<SettingProductInfoEntity> settingProductInfoEntities) {
        this.settingProductInfoEntities = settingProductInfoEntities;
    }
}
