package com.ejianc.business.ecxj.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.vo.SettingProductInfoVO;
import com.ejianc.business.ecxj.vo.SettingSupplierInfoVO;
import com.ejianc.business.ecxj.vo.YzwTenderVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.ecxj.bean.TypeSettingEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 集采类型设置
 * 
 * @author generator
 * 
 */
@Mapper
public interface TypeSettingMapper extends BaseCrudMapper<TypeSettingEntity> {

    @Select("select * from tenders_supplier_info where tender_no=#{tenderNo}")
    List<SettingSupplierInfoVO> getYzSupplier(@Param("tenderNo") String tenderNo);

    List<YzwTenderVO> getYzTenderRef(Page<YzwTenderVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param("tenantId") Long tenantId);

    @Select("select id tenderProductId, tenders_no, supplier_name, product_name, product_spec," +
            "product_unit, product_price, product_rate, product_lower_rate " +
            "from tenders_product_info where tenders_no=#{tenderCode}")
    List<SettingProductInfoVO> getYzProductByTenderCode(@Param("tenderCode") String tenderCode);

    @Select("select *, id tenderSupplierId from tenders_supplier_info where tenders_no=#{tendersNo}")
    List<SettingSupplierInfoVO> getYzSupplierByTenderNo(@Param("tendersNo") String tendersNo);

    @Update("update ejc_ecxj_type_setting set is_used=#{isUsed} where id =#{settingId}")
    boolean updateSettingStatus(@Param("settingId") String settingId, @Param("isUsed") int isUsed);

    @Update("update tenders_info set is_used=#{isUsed} where tenders_no =#{tendersNo}")
    boolean updateYzTendersStatus(@Param("tendersNo") String tendersNo, @Param("isUsed") int isUsed);
}
