package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.ecxj.bean.*;
import com.ejianc.business.ecxj.service.ICompareSupplierService;
import com.ejianc.business.ecxj.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ecxj.mapper.CompareMapper;
import com.ejianc.business.ecxj.service.ICompareService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 比选报价
 * 
 * @author generator
 * 
 */
@Service("compareService")
public class CompareServiceImpl extends BaseServiceImpl<CompareMapper, CompareEntity> implements ICompareService{

    private static final String ECXJ_COMPARE_BILL_CODE = "ECXJ_COMPARE_BILL_CODE";

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierService compareSupplierService;

    @Override
    public CompareVO generateCompareBill(NoticeVO noticeEntity) {
        // 发货单生成验收单
        CompareVO compareVO = new CompareVO();
        compareVO.setProjectId(noticeEntity.getProjectId());
        compareVO.setProjectName(noticeEntity.getProjectName());
        compareVO.setProjectSourceId(noticeEntity.getProjectSourceId());
        compareVO.setCropId(noticeEntity.getCropId());
        compareVO.setCropName(noticeEntity.getCropName());
        compareVO.setCropSourceId(noticeEntity.getCropSourceId());
        compareVO.setRealCorpId(noticeEntity.getRealCorpId());
        compareVO.setRealCorpName(noticeEntity.getRealCorpName());
        compareVO.setRealNcCorp(noticeEntity.getRealNcCorp());
        compareVO.setOrgId(noticeEntity.getOrgId());
        compareVO.setOrgName(noticeEntity.getOrgName());
        compareVO.setOrgSourceId(noticeEntity.getOrgSourceId());
        compareVO.setSubmitDeadline(noticeEntity.getSubmitDeadline());
        compareVO.setCompareTime(noticeEntity.getCompareTime());
        compareVO.setSettingId(noticeEntity.getSettingId());
        compareVO.setTenderId(noticeEntity.getTenderId());
        compareVO.setTenderNo(noticeEntity.getTenderNo());
        compareVO.setTenderName(noticeEntity.getTenderName());

        // 子表：供应商子表
        List<NoticeSupplierVO> noticeSupplierVOS = noticeEntity.getNoticeProductEntities().get(0).getNoticeSupplierEntities();
        for (NoticeSupplierVO noticeSupplierVO: noticeSupplierVOS) {
            noticeSupplierVO.setId(null);
            noticeSupplierVO.setPushStatus(null);
            noticeSupplierVO.setCreateUserCode(null);
            noticeSupplierVO.setCreateTime(null);
            noticeSupplierVO.setUpdateUserCode(null);
            noticeSupplierVO.setUpdateTime(null);
        }
        List<CompareSupplierInfoVO> compareSupplierVOS = BeanMapper.mapList(noticeSupplierVOS, CompareSupplierInfoVO.class);
        compareVO.setCompareSupplierInfoEntities( compareSupplierVOS );

        // 子表：物资明细子表
        List<NoticeProductVO> noticeProductEntities = noticeEntity.getNoticeProductEntities();
        List<CompareProductVO> compareProductVOS= BeanMapper.mapList(noticeProductEntities, CompareProductVO.class);
        compareVO.setCompareProductEntities(compareProductVOS);

//        List<CompareProductVO> compareProductVOList = compareVO.getCompareProductEntities();
//        // 孙表：物资明细下的供应商档案
//        for ( NoticeProductVO np: noticeProductEntities ) {
//            compareVO.set(BeanMapper.mapList(np.getNoticeSupplierEntities(), CompareSupplierVO.class));
//        }
        return compareVO;
    }

    @Override
    public CommonResponse<CompareVO> saveOrUpdate(CompareVO saveOrUpdateVO) {
//查询项目部上级组织的的来源id
        CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(saveOrUpdateVO.getOrgId());
        if(!orgParentVo.isSuccess()) {
            return CommonResponse.success("查询组织详情失败！");
        }

        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ECXJ_COMPARE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        CompareEntity entity = BeanMapper.map(saveOrUpdateVO, CompareEntity.class);
        saveOrUpdate(entity, false);

        List<CompareProductEntity> compareProductEntities = entity.getCompareProductEntities();  // 获取清单列表实体
        List<CompareSupplierEntity> saveRedirects = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(compareProductEntities)) {
            for (CompareProductEntity info : compareProductEntities) {
                List<CompareSupplierEntity> list = info.getCompareSupplierEntities();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (CompareSupplierEntity re : list) {
                        re.setProductId(info.getId());
                        re.setId(null);
                        saveRedirects.add(re);
                    }
                }
            }
            compareSupplierService.saveBatch(saveRedirects);
        }

//        saveOrUpdate(entity, false);
        CompareVO vo = BeanMapper.map(entity, CompareVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CompareVO queryDetail(Long id) {
        CompareEntity entity = this.selectById(id);
        List<CompareProductEntity> infoEntities = entity.getCompareProductEntities();
        CompareVO vo = BeanMapper.map(entity, CompareVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List<CompareProductVO> settingProducInfoVOS = BeanMapper.mapList(infoEntities, CompareProductVO.class);
            QueryParam queryParam = null;
            for (CompareProductVO infovo : settingProducInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("product_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<CompareSupplierEntity> redirectEntities = compareSupplierService.queryList(queryParam, false);
                infovo.setCompareSupplierEntities(BeanMapper.mapList(redirectEntities, CompareSupplierVO.class));
            }
            vo.setCompareProductEntities(settingProducInfoVOS);
        }
        return vo;
    }

    @Override
    public boolean deleteCompare(List<CompareVO> vos) {
        super.removeByIds(vos.stream().map(CompareVO::getId).collect(Collectors.toList()),true);
        boolean flag = true;
//        for (CompareVO noticeVO : vos) {
//            flag = settingService.updateSettingProductStatus(noticeVO.getSettingId().toString(), 0);
//            if (!flag){
//                throw new BusinessException("删除设置，更改类型设置引用状态失败！");
//            }
//        }
        return flag;
    }

}
