package com.ejianc.business.ecxj.service.impl;

import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import com.ejianc.business.ecxj.bean.NoticeProductEntity;
import com.ejianc.business.ecxj.bean.NoticeSupplierEntity;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.business.ecxj.vo.NoticeProductVO;
import com.ejianc.business.ecxj.vo.NoticeSupplierVO;
import com.ejianc.business.ecxj.vo.NoticeVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("notice") 
public class NoticeBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ISupplierApi supplierApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		NoticeVO noticeVO = noticeService.queryDetail(billId);
		//推送供方
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = noticeService.getAccessToken(headers);
		// 比价单，compareVO
		if(tokenres.isSuccess()){
			// 获取供应商信息，将供应商赋值给物资明细中的Supplier字段
			NoticeProductVO noticeProductEntity = noticeVO.getNoticeProductEntities().get(0);
			List<NoticeSupplierVO> noticeSupplierEntities = noticeProductEntity.getNoticeSupplierEntities(); // 1、供应商列表，遍历每个供应商
			for (NoticeSupplierVO noticeSupplierEntity : noticeSupplierEntities) {
				CommonResponse<SupplierVO> supplier = supplierApi.queryBySourceId(noticeSupplierEntity.getSupplierCreditCode());
				if(supplier.isSuccess()){
					SupplierVO  supplierVO = supplier.getData();
					noticeVO.setSupplierSourceId(supplierVO.getSourceId());
					noticeVO.setSupplierName(supplierVO.getName());
				}
				logger.info("获取供方token--"+headers);
				CommonResponse<String> pushres = noticeService.pushNotice(headers,noticeVO);
				logger.info("获取推送供方结果--"+pushres);
				if(pushres.isSuccess()){
					//推送成功后处理逻辑
					noticeSupplierEntity.setPushStatus(1);  // 已推送
//					noticeService.saveOrUpdate(noticeEntity,false);
				}else{
					return pushres;
				}
			}
//			CompareEntity entity = BeanMapper.map(noticeEntity, CompareEntity.class);
		}else{
			return tokenres;
		}
		/*
		生成比价单
		 */
		CompareVO compareVO= compareService.generateCompareBill(noticeVO);
		compareService.saveOrUpdate(compareVO);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
