package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.ecxj.bean.NoticeProductEntity;
import com.ejianc.business.ecxj.bean.NoticeSupplierEntity;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.INoticeSupplierService;
import com.ejianc.business.ecxj.service.ITypeSettingService;
import com.ejianc.business.ecxj.util.HttpTookit;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.business.ecxj.vo.NoticeProductVO;
import com.ejianc.business.ecxj.vo.NoticeSupplierVO;
import com.ejianc.business.ecxj.vo.NoticeVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ecxj.mapper.NoticeMapper;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import com.ejianc.business.ecxj.service.INoticeService;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 询价通知实体
 * 
 * @author generator
 * 
 */
@Service("noticeService")
public class NoticeServiceImpl extends BaseServiceImpl<NoticeMapper, NoticeEntity> implements INoticeService{

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjNoticeUrl}")
    private String wjNoticeUrl;

//    @Value("${openApi.wjDelNoticeUrl}")
//    private String wjDelNoticeUrl;

    private static final String ECXJ_NOTICE_BILL_CODE = "CSCEC5B_ECXJ_NOTICE";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private ITypeSettingService settingService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private INoticeSupplierService noticeSupplierService;
    @Autowired
    private ISupplierApi supplierApi;
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        NoticeVO noticeVO = noticeService.queryDetail(billId);
//        NoticeEntity noticeEntity = noticeService.selectById(billId);
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = noticeService.getAccessToken(headers);
        logger.info("获取供方token  tokenres.isSuccess() --"+tokenres.isSuccess());
        // 比价单，compareVO
        if(tokenres.isSuccess()){
            // 获取供应商信息，将供应商赋值给物资明细中的Supplier字段
            NoticeProductVO noticeProductVO = noticeVO.getNoticeProductEntities().get(0);
            List<NoticeSupplierVO> noticeSupplierVOS = noticeProductVO.getNoticeSupplierEntities(); // 1、供应商列表，遍历每个供应商
            for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
                CommonResponse<SupplierVO> supplier = supplierApi.queryBySourceId(noticeSupplierVO.getSupplierCreditCode());
                if(supplier.isSuccess()){
                    SupplierVO  supplierVO = supplier.getData();
                    noticeVO.setSupplierSourceId(supplierVO.getSourceId());
                    noticeVO.setSupplierName(supplierVO.getName());
                    noticeVO.setSupplierCreditCode(supplierVO.getSocialCreditCode());
                }
                logger.info("获取供方token--"+headers);
                CommonResponse<String> pushres = noticeService.pushNotice(headers,noticeVO);
                logger.info("获取推送供方结果--"+pushres);
                if(pushres.isSuccess()){
                    //推送成功后处理逻辑
                    noticeSupplierVO.setPushStatus(1);  // 已推送
//					noticeService.saveOrUpdate(noticeEntity,false);
                }else{
                    return pushres;
                }
            }
//			CompareEntity entity = BeanMapper.map(noticeEntity, CompareEntity.class);
        }else{
            return tokenres;
        }
		/*
		生成比价单
		 */
        CompareVO compareVO= compareService.generateCompareBill(noticeVO);
        compareService.saveOrUpdate(compareVO);
        return CommonResponse.success();
    }
    @Override
    public CommonResponse<NoticeVO> saveOrUpdate(NoticeVO saveOrUpdateVO) {

        // 查询项目部NC 实际所属组织的的来源id
//        CommonResponse<ProjectRegisterVO> project = projectApi.queryProjectBySourceId(saveOrUpdateVO.getProjectSourceId());
//        if(project.isSuccess()){
//            saveOrUpdateVO.setRealCorpId(project.getData().getRealCorpId());
//            saveOrUpdateVO.setRealNcCorp(project.getData().getRealNcCorp());
//            saveOrUpdateVO.setRealCorpName(project.getData().getRealCorpName());
//        } else {
//            throw new BusinessException("查询项目信息详情失败！");
//        }

        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ECXJ_NOTICE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        NoticeEntity entity = BeanMapper.map(saveOrUpdateVO, NoticeEntity.class);

        saveOrUpdate(entity, false);
        // 更改类型设置引用状态
        boolean flag = settingService.updateSettingProductStatus(entity.getSettingId().toString(), 1);
        if (!flag){
            throw new BusinessException("更改类型设置引用状态失败！");
        }
        List<NoticeProductEntity> settingProductInfoEntities = entity.getNoticeProductEntities();  // 获取清单列表实体

        List<NoticeSupplierEntity> saveRedirects = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(settingProductInfoEntities)) {
            for (NoticeProductEntity info : settingProductInfoEntities) {
                List<NoticeSupplierEntity> list = info.getNoticeSupplierEntities();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (NoticeSupplierEntity re : list) {
                        re.setProductId(info.getId());
                        re.setId(null);
                        saveRedirects.add(re);
                    }
                }
            }
            noticeSupplierService.saveBatch(saveRedirects);
        }

//        saveOrUpdate(entity, false);
        NoticeVO vo = BeanMapper.map(entity, NoticeVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity entity = this.selectById(id);
        List<NoticeProductEntity> infoEntities = entity.getNoticeProductEntities();
        NoticeVO vo = BeanMapper.map(entity, NoticeVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List<NoticeProductVO> settingProducInfoVOS = BeanMapper.mapList(infoEntities, NoticeProductVO.class);
            QueryParam queryParam = null;
            for (NoticeProductVO infovo : settingProducInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("product_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<NoticeSupplierEntity> redirectEntities = noticeSupplierService.queryList(queryParam, false);
                infovo.setNoticeSupplierEntities(BeanMapper.mapList(redirectEntities, NoticeSupplierVO.class));
            }
            vo.setNoticeProductEntities(settingProducInfoVOS);
        }
        return vo;
    }

    @Override
    public boolean deleteNotice(List<NoticeVO> vos) {
        super.removeByIds(vos.stream().map(NoticeVO::getId).collect(Collectors.toList()),true);
        boolean flag = true;
        for (NoticeVO noticeVO : vos) {
            flag = settingService.updateSettingProductStatus(noticeVO.getSettingId().toString(), 0);
            if (!flag){
                throw new BusinessException("删除设置，更改类型设置引用状态失败！");
            }
        }
        return flag;
    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        headers.put("X-Token", "987b75e2727ae55289abd70d3f5864e6");
//        if(redisTemplate.opsForValue().get("X-Open-Token") != null){
//            //若存在，直接放到header中
//            logger.info("------------  redisTemplate里有token  ------------"+redisTemplate.opsForValue().get("X-Open-Token"));
//            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
//        }else{
//            String initContextUrl = wjTokenUrl;
//            String responseStr = null;
//            try {
//                responseStr = HttpTookit.get(initContextUrl, null);
//                JSONObject json = JSONObject.parseObject(responseStr);
//                if("200".equals(json.get("code").toString())){
//                    JSONObject data = json.getJSONObject("body");
//                    String access_token = data.get("token").toString();
//                    headers.put("X-Open-Token", access_token);
//                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
//                    redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
//                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
//                }else{
//                    //请求失败，输出错误信息
//                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
//                }
//            } catch (GeneralSecurityException e) {
//                logger.info("GeneralSecurityException 异常"+e.getMessage());
//                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
//            } catch (IOException e) {
//                logger.info("IOException 异常"+e.getMessage());
//                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
//            }
//        }
        return CommonResponse.success();
    }

    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushNotice(Map<String, String> headers,NoticeVO noticeEntity){
        String url = wjNoticeUrl;
        NoticeVO noticeVO = BeanMapper.map(noticeEntity, NoticeVO.class);
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(noticeVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(noticeVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送询价通知异常!");
        }
    }


}
