package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.SettingProductInfoEntity;
import com.ejianc.business.ecxj.bean.SettingSupplierInfoEntity;
import com.ejianc.business.ecxj.service.ISettingSupplierInfoService;
import com.ejianc.business.ecxj.vo.SettingProductInfoVO;
import com.ejianc.business.ecxj.vo.SettingSupplierInfoVO;
import com.ejianc.business.ecxj.vo.TypeSettingVO;
import com.ejianc.business.ecxj.vo.YzwTenderVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ecxj.mapper.TypeSettingMapper;
import com.ejianc.business.ecxj.bean.TypeSettingEntity;
import com.ejianc.business.ecxj.service.ITypeSettingService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 集采类型设置
 * 
 * @author generator
 * 
 */
@Service("typeSettingService")
public class TypeSettingServiceImpl extends BaseServiceImpl<TypeSettingMapper, TypeSettingEntity> implements ITypeSettingService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettingSupplierInfoService settingSupplierInfoService;

    @Override
    @Transactional
    public CommonResponse<TypeSettingVO> saveOrUpdate(TypeSettingVO saveorUpdateVO) {
        logger.error("setting save json is " + JSONObject.toJSONString(saveorUpdateVO));
        TypeSettingEntity entity = BeanMapper.map(saveorUpdateVO, TypeSettingEntity.class);
        List<SettingProductInfoVO> productInfoList = baseMapper.getYzProductByTenderCode(entity.getTenderCode());
        entity.setSettingProductInfoEntities(BeanMapper.mapList(productInfoList, SettingProductInfoEntity.class));
        saveOrUpdate(entity, false);
        boolean flag = baseMapper.updateYzTendersStatus(entity.getTenderCode(), 1);
        if (!flag){
            throw new BusinessException("更改云筑网招标状态失败！");
        }

        List<SettingProductInfoEntity> settingProductInfoEntities = entity.getSettingProductInfoEntities();  // 获取清单列表实体
        for (SettingProductInfoEntity s : settingProductInfoEntities) {
            List<SettingSupplierInfoEntity> supplierInfoList = BeanMapper.mapList(baseMapper.getYzSupplierByTenderNo(s.getTendersNo()), SettingSupplierInfoEntity.class);
            List<SettingSupplierInfoEntity> saveRedirects = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(supplierInfoList)) {
                for (SettingSupplierInfoEntity re : supplierInfoList) {
                    re.setProductId(s.getId());
                    re.setId(null);
                    re.setCreateTime(null);
                    saveRedirects.add(re);
                }
            }
            settingSupplierInfoService.saveBatch(saveRedirects);
        }

//        saveOrUpdate(entity, false);         // 将Redirect存储到vo中，用于返回显示
        TypeSettingVO vo = BeanMapper.map(entity, TypeSettingVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public TypeSettingVO queryDetail(Long id) {
        TypeSettingEntity entity = this.selectById(id);
        List<SettingProductInfoEntity> infoEntities = entity.getSettingProductInfoEntities();
        TypeSettingVO vo = BeanMapper.map(entity, TypeSettingVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List<SettingProductInfoVO> settingProducInfoVOS = BeanMapper.mapList(infoEntities, SettingProductInfoVO.class);
            QueryParam queryParam = null;
            for (SettingProductInfoVO infovo : settingProducInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("product_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<SettingSupplierInfoEntity> redirectEntities = settingSupplierInfoService.queryList(queryParam, false);
                infovo.setSettingSupplierInfoEntities(BeanMapper.mapList(redirectEntities, SettingSupplierInfoVO.class));
            }
            vo.setSettingProductInfoEntities(settingProducInfoVOS);
        }
        return vo;
    }

    @Override
    public boolean updateSettingProductStatus(String settingId, int isUsed) {
        return baseMapper.updateSettingStatus(settingId, isUsed);
    }

    @Override
    public boolean deleteSetting(List<TypeSettingVO> vos) {
        super.removeByIds(vos.stream().map(TypeSettingVO::getId).collect(Collectors.toList()),true);
        boolean flag = true;
        for (TypeSettingVO t : vos) {
            flag = baseMapper.updateYzTendersStatus(t.getTenderCode(), 0);
            if (!flag){
                throw new BusinessException("删除设置，更改云筑网物资招标状态失败！");
            }
        }
        return flag;
    }

    @Override
    public List<SettingSupplierInfoVO> getYzSupplier(String tenderNo) {
        return baseMapper.getYzSupplier(tenderNo);
    }

    @Override
    public List<YzwTenderVO> getYzTenderRef(Page<YzwTenderVO> page, QueryWrapper wrapper, Long tenantid) {
        List<YzwTenderVO> list = baseMapper.getYzTenderRef(page, wrapper,tenantid);
        return list;
    }
}
