package com.ejianc.business.ecxj.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 询价通知实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_notice")
public class NoticeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源id
    @TableField(value="crop_id")
    private Long cropId; // 项目所属组织id
    @TableField(value="crop_name")
    private String cropName; // 所属公司
    @TableField(value="crop_source_id")
    private String cropSourceId; // 项目所属组织来源id
    @TableField(value="real_corp_id")
    private Long realCorpId; // NC所属组织ID
    @TableField(value="real_nc_corp")
    private String realNcCorp; // NC所属组织PK
    @TableField(value="real_corp_name")
    private String realCorpName; // NC所属组织名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_source_id")
    private String orgSourceId; // 组织来源id
    @TableField(value="org_name")
    private String orgName; // 组织名称

    @TableField(value="material_type_id")
    private String materialTypeId; // 集采材料类型Id
    @TableField(value="material_type_name")
    private String materialTypeName; // 集采材料类型名称
    @TableField(value="submit_deadline")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date submitDeadline; // 填报截止日期
    @TableField(value="compare_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date compareTime; // 比选时间

    @TableField(value="setting_id")
    private Long settingId; // 引用的类型设置Id
    @TableField(value="tender_id")
    private Long tenderId; // 云筑招标Id
    @TableField(value="tender_no")
    private String tenderNo; // 云筑招标编号
    @TableField(value="tender_name")
    private String tenderName; // 云筑招标名称

    @TableField(value="quote_type")
    private Integer quoteType; // 报价方式
    @TableField(value="notification")
    private String notification; // 通知内容
    @TableField(value="create_name")
    private String createName; // 申请人
    @TableField(value="supplier_source_id")
    private String supplierSourceId; // 供应商Pk
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="supplier_credit_code")
    private String supplierCreditCode; // 供应商名称

    @TableField(exist = false)
    @SubEntity(serviceName = "noticeSupplierService",pidName = "noticeId")
    private List<NoticeSupplierEntity> noticeSupplierEntities = new ArrayList<>(); // 通知物资清单实体


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public Long getCropId() {
        return cropId;
    }

    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    public String getCropName() {
        return cropName;
    }

    public void setCropName(String cropName) {
        this.cropName = cropName;
    }
    public String getCropSourceId() {
        return cropSourceId;
    }

    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }
    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }
    public String getRealNcCorp() {
        return realNcCorp;
    }

    public void setRealNcCorp(String realNcCorp) {
        this.realNcCorp = realNcCorp;
    }
    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(String materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Date getSubmitDeadline() {
        return submitDeadline;
    }

    public void setSubmitDeadline(Date submitDeadline) {
        this.submitDeadline = submitDeadline;
    }
    public Date getCompareTime() {
        return compareTime;
    }

    public void setCompareTime(Date compareTime) {
        this.compareTime = compareTime;
    }

    public Long getSettingId() {
        return settingId;
    }

    public void setSettingId(Long settingId) {
        this.settingId = settingId;
    }

    public Long getTenderId() {
        return tenderId;
    }

    public void setTenderId(Long tenderId) {
        this.tenderId = tenderId;
    }
    public String getTenderNo() {
        return tenderNo;
    }

    public void setTenderNo(String tenderNo) {
        this.tenderNo = tenderNo;
    }
    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    public Integer getQuoteType() {
        return quoteType;
    }

    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }
    public String getNotification() {
        return notification;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }

    public List<NoticeSupplierEntity> getNoticeSupplierEntities() {
        return noticeSupplierEntities;
    }

    public void setNoticeSupplierEntities(List<NoticeSupplierEntity> noticeSupplierEntities) {
        this.noticeSupplierEntities = noticeSupplierEntities;
    }
}
