package com.ejianc.business.ecxj.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 云筑网供应商实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_type_setting_supplier")
public class SettingSupplierInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="setting_id")
    private Long settingId; // 商品Id
    @TableField(value="tender_supplier_id")
    private Long tenderSupplierId; // 云筑供应商Id
    @TableField(value="tenders_no")
    private String tendersNo; // 招标编号
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="supplier_credit_code")
    private String supplierCreditCode; // 供应商纳税人编号
    @TableField(value="supplier_contract_person")
    private String supplierContractPerson; // 中标供应商联系人
    @TableField(value="supplier_contract_phone")
    private String supplierContractPhone; // 中标供应商联系方式
    @TableField(value="create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime; // 创建时间

    @TableField(exist=false)
    @SubEntity(serviceName="settingProductInfoService",pidName = "supplierId")
    private List<SettingProductInfoEntity> settingProductInfoEntities = new ArrayList<>(); // 设置物资清单实体

    public Long getSettingId() {
        return settingId;
    }

    public void setSettingId(Long settingId) {
        this.settingId = settingId;
    }

    public Long getTenderSupplierId() {
        return tenderSupplierId;
    }

    public void setTenderSupplierId(Long tenderSupplierId) {
        this.tenderSupplierId = tenderSupplierId;
    }

    public String getTendersNo() {
        return tendersNo;
    }

    public void setTendersNo(String tendersNo) {
        this.tendersNo = tendersNo;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }

    public String getSupplierContractPerson() {
        return supplierContractPerson;
    }

    public void setSupplierContractPerson(String supplierContractPerson) {
        this.supplierContractPerson = supplierContractPerson;
    }

    public String getSupplierContractPhone() {
        return supplierContractPhone;
    }

    public void setSupplierContractPhone(String supplierContractPhone) {
        this.supplierContractPhone = supplierContractPhone;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<SettingProductInfoEntity> getSettingProductInfoEntities() {
        return settingProductInfoEntities;
    }

    public void setSettingProductInfoEntities(List<SettingProductInfoEntity> settingProductInfoEntities) {
        this.settingProductInfoEntities = settingProductInfoEntities;
    }
}
