package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.*;
import com.ejianc.business.ecxj.service.*;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.util.C;
import com.ejianc.business.ecxj.util.HttpTookit;
import com.ejianc.business.ecxj.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ecxj.mapper.CompareMapper;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 比选报价
 * 
 * @author generator
 * 
 */
@Service("compareService")
public class CompareServiceImpl extends BaseServiceImpl<CompareMapper, CompareEntity> implements ICompareService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ECXJ_COMPARE_BILL_CODE = "ECXJ_COMPARE_BILL_CODE";

    @Value("${openApi.wjNoticePostDeadlineUrl}")
    private String wjNoticePostDeadlineUrl;

    @Value("${img.serverPath}")
    private String serverPath;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IFileService fileService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierService compareSupplierService;
    @Autowired
    private ICompareProductService compareProductService;

    @Override
    public CompareVO generateCompareBill(NoticeVO noticeEntity) {
        // 发货单生成验收单
        CompareVO compareVO = new CompareVO();
        compareVO.setNoticeId(noticeEntity.getId());
        compareVO.setProjectId(noticeEntity.getProjectId());
        compareVO.setProjectName(noticeEntity.getProjectName());
        compareVO.setProjectSourceId(noticeEntity.getProjectSourceId());
        compareVO.setCropId(noticeEntity.getCropId());
        compareVO.setCropName(noticeEntity.getCropName());
        compareVO.setCropSourceId(noticeEntity.getCropSourceId());
        compareVO.setRealCorpId(noticeEntity.getRealCorpId());
        compareVO.setRealCorpName(noticeEntity.getRealCorpName());
        compareVO.setRealNcCorp(noticeEntity.getRealNcCorp());
        compareVO.setOrgId(noticeEntity.getOrgId());
        compareVO.setOrgName(noticeEntity.getOrgName());
        compareVO.setOrgSourceId(noticeEntity.getOrgSourceId());
        compareVO.setMaterialTypeId(noticeEntity.getMaterialTypeId());
        compareVO.setMaterialTypeName(noticeEntity.getMaterialTypeName());
        compareVO.setOrgSourceId(noticeEntity.getOrgSourceId());
        compareVO.setSubmitDeadline(noticeEntity.getSubmitDeadline());
        compareVO.setCompareTime(noticeEntity.getCompareTime());
        compareVO.setSettingId(noticeEntity.getSettingId());
        compareVO.setTenderId(noticeEntity.getTenderId());
        compareVO.setTenderNo(noticeEntity.getTenderNo());
        compareVO.setTenderName(noticeEntity.getTenderName());
        compareVO.setQuoteType(noticeEntity.getQuoteType());
        compareVO.setCompareStatus(0);
        compareVO.setNotification(noticeEntity.getNotification());

        // 子表：供应商子表
        List<NoticeSupplierVO> noticeSupplierVOS = noticeEntity.getNoticeSupplierEntities();
        for (NoticeSupplierVO noticeSupplierVO: noticeSupplierVOS) {
            noticeSupplierVO.setId(null);
            noticeSupplierVO.setPushStatus(0);
            noticeSupplierVO.setPushStatus(null);
            noticeSupplierVO.setCreateTime(null);
            noticeSupplierVO.setUpdateUserCode(null);
            noticeSupplierVO.setUpdateTime(null);
        }
        List<CompareSupplierVO> compareSupplierVOS = BeanMapper.mapList(noticeSupplierVOS, CompareSupplierVO.class);
        // 孙表：物资明细子表
        for (CompareSupplierVO c : compareSupplierVOS) {
            for (NoticeSupplierVO n: noticeSupplierVOS) {
                if (c.getSupplierCreditCode().equals(n.getSupplierCreditCode())) {
                    List<CompareProductVO> compareProductVOS = BeanMapper.mapList(n.getNoticeProductEntities(), CompareProductVO.class);
                    for (CompareProductVO cp : compareProductVOS) {
                        cp.setCreateTime(null);
                        cp.setUpdateUserCode(null);
                        cp.setUpdateTime(null);
                    }
                    c.setCompareProductEntities( compareProductVOS );
                }
            }
        }
        compareVO.setCompareSupplierEntities( compareSupplierVOS );

        return compareVO;
    }

    @Override
    public CommonResponse<CompareVO> saveOrUpdate(CompareVO saveOrUpdateVO) {
        //查询项目部上级组织的的来源id
        CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(saveOrUpdateVO.getOrgId());
        if(!orgParentVo.isSuccess()) {
            return CommonResponse.success("查询组织详情失败！");
        }

        String operateType = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
            operateType = "add";
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ECXJ_COMPARE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        } else {
            operateType = "edit";
        }

        CompareEntity entity = BeanMapper.map(saveOrUpdateVO, CompareEntity.class);
        saveOrUpdate(entity, false);
        if (entity.getCompareStatus()!=null && entity.getCompareStatus() == 2) {   // 流标，则更改状态，直接将数据返回
            CompareVO vo = BeanMapper.map(entity, CompareVO.class);
            return CommonResponse.success("保存或修改单据成功！",vo);
        }

        List<CompareSupplierEntity> compareSupplierEntities = entity.getCompareSupplierEntities();

        /** 编辑态，清空商品信息，重新插入新增商品信息 */
        if ("edit".equals(operateType)) {
            //删除所有
            List<Long> sList = saveOrUpdateVO.getCompareSupplierEntities().stream().map(CompareSupplierVO::getId).collect(Collectors.toList());
            compareProductService.remove(new QueryWrapper<CompareProductEntity>().in("supplier_id", sList));
        }
        List<CompareProductEntity> saveRedirects = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(compareSupplierEntities)) {
            for (CompareSupplierEntity info : compareSupplierEntities) {
                List<CompareProductEntity> list = info.getCompareProductEntities();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (CompareProductEntity re : list) {
                        re.setSupplierId(info.getId());
                        re.setId(null);
                        saveRedirects.add(re);
                    }
                }
            }
            compareProductService.saveBatch(saveRedirects);
        }

//        saveOrUpdate(entity, false);
        CompareVO vo = BeanMapper.map(entity, CompareVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CompareVO queryDetail(Long id) {
        CompareEntity entity = this.selectById(id);
        List<CompareSupplierEntity> infoEntities = entity.getCompareSupplierEntities();
        CompareVO vo = BeanMapper.map(entity, CompareVO.class);

        // 判断是否超过比选日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowDateTime = sdf.format(new Date());
        String compareTime = sdf.format( entity.getCompareTime() );
        Integer overTimeFlag = nowDateTime.compareTo( compareTime );

        if (infoEntities != null && infoEntities.size() > 0) {
            List<CompareSupplierVO> settingSupplierInfoVOS = BeanMapper.mapList(infoEntities, CompareSupplierVO.class);
            QueryParam queryParam = null;      // 物资商品
            QueryParam queryParam1 = null;     // 附件
            for (CompareSupplierVO infovo : settingSupplierInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("supplier_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<CompareProductEntity> redirectEntities = compareProductService.queryList(queryParam, false);
                infovo.setCompareProductEntities(BeanMapper.mapList(redirectEntities, CompareProductVO.class));

                if (overTimeFlag > 0) {
                    queryParam1 = new QueryParam();
                    queryParam1.getParams().put("supplier_id", new Parameter(QueryParam.EQ, infovo.getId()));
                    List<FileEntity> fileEntities = fileService.queryList(queryParam1, false);
                    infovo.setFileList(BeanMapper.mapList(fileEntities, FileVO.class));
                } else {
                    infovo.setFileList(null);
                }

            }
            vo.setCompareSupplierEntities(settingSupplierInfoVOS);
        }
        return vo;
    }

    @Override
    public CompareVO updateCompare(NoticeSuplVO noticeSuplVO) {

        Integer submitStatus = noticeSuplVO.getSubmitStatus();

        // 1、推送来的询价单
        String supplierCreditCode = noticeSuplVO.getSupplierCreditCode();
        Long lightNoticeId = noticeSuplVO.getLightNoticeId();
        BigDecimal sumMny = noticeSuplVO.getSumMny();
        List<NoticeSuplProductVO> noticeSuplProductEntities = noticeSuplVO.getNoticeSuplProductEntities();
        List<FileVO> fileVOList = noticeSuplVO.getFileList();

        // 2、查询到对应的比价单
        LambdaQueryWrapper<CompareEntity> queryWrapper = Wrappers.<CompareEntity>lambdaQuery();
        queryWrapper.eq(CompareEntity::getNoticeId, lightNoticeId);
        CompareEntity compareEntity = compareService.getOne(queryWrapper);
        LambdaQueryWrapper<CompareSupplierEntity> lambda2 = Wrappers.<CompareSupplierEntity>lambdaQuery();
        lambda2.eq(CompareSupplierEntity::getCompareId, compareEntity.getId());
        List<CompareSupplierEntity> compareSupplierEntities = compareSupplierService.list(lambda2);
        compareEntity.setCompareSupplierEntities(compareSupplierEntities);

        // 更新供应商推送状态
        for (CompareSupplierEntity c : compareSupplierEntities) {
            // 判断比价单中的供应商信息 是否与 推送来询价单的供应商noticeVO一样
            if (c.getSupplierCreditCode().equals(supplierCreditCode)) {
                if (submitStatus == 3) {             // 供方已拒绝
                    c.setPushStatus(2);              // 设置供应商状态：已拒绝
                } else {
                    LambdaQueryWrapper<CompareProductEntity> lambda3 = Wrappers.<CompareProductEntity>lambdaQuery();
                    lambda3.eq(CompareProductEntity::getSupplierId, c.getId());
                    List<CompareProductEntity> compareProductEntities = compareProductService.list(lambda3);
                    for (CompareProductEntity cp : compareProductEntities) {
                        for (NoticeSuplProductVO nsp : noticeSuplProductEntities) {
                            if (cp.getTenderProductId().equals(nsp.getTenderProductId())) {
                                cp.setFillPrice(nsp.getFillPrice());
                            }
                        }
                    }
                    c.setCompareProductEntities(compareProductEntities);
                    c.setPushStatus(1);
                    c.setSumMny(sumMny);
                    // 供方上传附件保存至轻量化附件
                    if (CollectionUtils.isNotEmpty(fileVOList) && fileVOList.size() != 0) {
                        saveFile(fileVOList, c.getId());
                        List<FileEntity> fileEntities = BeanMapper.mapList(fileVOList, FileEntity.class);
                        c.setFileList(fileEntities);
                    }
                }
            }
        }
        compareEntity.setCompareSupplierEntities(compareSupplierEntities);
        CompareVO compareVO = BeanMapper.map(compareEntity, CompareVO.class);
        saveOrUpdate(compareVO);
        return compareVO;
    }

    //保存推送照片信息
    public boolean saveFile(List<FileVO> fileVOList,Long id){
        // 1、查询之前的附件，并删除
        LambdaQueryWrapper<FileEntity> queryWrapper = Wrappers.<FileEntity>lambdaQuery();
        queryWrapper.eq(FileEntity::getSupplierId, id);
        fileService.remove(queryWrapper);

        // 3、更新新推送的fileVOList
        for (FileVO f : fileVOList) {
            f.setSupplierId(id);
        }
        List<FileEntity> fileEntities = BeanMapper.mapList(fileVOList, FileEntity.class);
        return fileService.saveBatch(fileEntities);
    }

    @Override
    public boolean deleteCompare(List<CompareVO> vos) {
        super.removeByIds(vos.stream().map(CompareVO::getId).collect(Collectors.toList()),true);
        boolean flag = true;
//        for (CompareVO noticeVO : vos) {
//            flag = settingService.updateSettingProductStatus(noticeVO.getSettingId().toString(), 0);
//            if (!flag){
//                throw new BusinessException("删除设置，更改类型设置引用状态失败！");
//            }
//        }
        return flag;
    }

    @Override
    public CompareVO submit(CompareVO vo) {
        /**
         *  发消息通知供方中标（弃）
         *  保存中标单位，发送中标信息在审批完成后
         */
        saveOrUpdate(vo);
        /**
        String corpName = vo.getCropName();
        String projectName = vo.getProjectName();
        String materialTypeName = vo.getMaterialTypeName();
        List<CompareSupplierTenderVO> compareSupplierTenderVOS = vo.getCompareSupplierTenderEntities();
//        String yzTenderNo = vo.getTenderNo();
        for (CompareSupplierTenderVO c : compareSupplierTenderVOS) {
//            String supplierName = c.getTenderSupplierName();
            String linkman = c.getSupplierContractPerson();
            String phone = c.getSupplierContractPhone();
            String bizid = AliyunSMSUtil.sendSMSLogin1(C.ECXUN_TENDER, phone, linkman, projectName, materialTypeName, corpName);  // 供应商、联系人、联系电话、云筑中标编号
        }
        */
        return vo;
    }

    @Override
    @Transactional
    public CommonResponse<String> postDeadline(CompareVO vo) {
        saveOrUpdate(vo);
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = noticeService.getAccessToken(headers);
        Long noticeId = vo.getNoticeId();
        NoticeVO noticeVO = noticeService.queryDetail(noticeId);
        noticeVO.setSubmitDeadline(vo.getSubmitDeadline());
        NoticeSuplVO noticeSuplVO = BeanMapper.map(noticeVO, NoticeSuplVO.class);
        // 比价单，compareVO
        if(tokenres.isSuccess()){
            // 获取供应商信息，将供应商赋值给物资明细中的Supplier字段
            List<NoticeSupplierVO> noticeSupplierVOS = noticeVO.getNoticeSupplierEntities(); // 1、供应商列表，遍历每个供应商
            for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
                CommonResponse<List<SupplierVO>> supplier = supplierApi.queryByCreditCode(noticeSupplierVO.getSupplierCreditCode());
                if(supplier.isSuccess() && CollectionUtils.isNotEmpty(supplier.getData())){
                    SupplierVO  supplierVO = supplier.getData().get(0);
                    noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
                    noticeSuplVO.setSupplierName(supplierVO.getName());
                    noticeSuplVO.setSupplierCreditCode(supplierVO.getSocialCreditCode());
                }
                logger.info("获取供方token--"+headers);
                CommonResponse<String> pushres = this.pushNoticePostDeadline(headers, noticeSuplVO);
                logger.info("获取推送供方结果--"+pushres);
                if(pushres.isSuccess()){
                    //推送成功后处理逻辑
                    return CommonResponse.success("推迟时间成功！");
                }else{
                    return pushres;
                }
            }
            return  CommonResponse.success("推迟时间成功！");
        }else{
            return tokenres;
        }
    }

    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushNoticePostDeadline(Map<String, String> headers,NoticeSuplVO noticeSuplVO){
        String url = wjNoticePostDeadlineUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(noticeSuplVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(noticeSuplVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送询价通知异常!");
        }
    }

}
