package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.ecxj.bean.NoticeProductEntity;
import com.ejianc.business.ecxj.bean.NoticeSupplierEntity;
import com.ejianc.business.ecxj.service.*;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.util.C;
import com.ejianc.business.ecxj.util.HttpTookit;
import com.ejianc.business.ecxj.vo.*;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ecxj.mapper.NoticeMapper;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 询价通知实体
 * 
 * @author generator
 * 
 */
@Service("noticeService")
public class NoticeServiceImpl extends BaseServiceImpl<NoticeMapper, NoticeEntity> implements INoticeService{

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjNoticeUrl}")
    private String wjNoticeUrl;

    @Value("${openApi.wjDelNoticeUrl}")
    private String wjDelNoticeUrl;

    private static final String ECXJ_NOTICE_BILL_CODE = "CSCEC5B_ECXJ_NOTICE";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private ITypeSettingService settingService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private INoticeSupplierService noticeSupplierService;
    @Autowired
    private INoticeProductService noticeProductService;
    @Autowired
    private ISupplierApi supplierApi;
    @Override
    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        NoticeVO noticeVO = noticeService.queryDetail(billId);
        NoticeSuplVO noticeSuplVO = BeanMapper.map(noticeVO, NoticeSuplVO.class);
        String yzTenderNo = noticeVO.getTenderNo();
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = noticeService.getAccessToken(headers);
        logger.info("获取供方token  tokenres.isSuccess() --"+tokenres.isSuccess());
        // 比价单，compareVO
        if(tokenres.isSuccess()){
            // 获取供应商信息，将供应商赋值给物资明细中的Supplier字段
            List<NoticeSupplierVO> noticeSupplierVOS = noticeVO.getNoticeSupplierEntities(); // 1、供应商列表，遍历每个供应商
            for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
                /**
                 *  接口更改：根据供应商信用编码，查询供应商信息
                 */
                CommonResponse<List<SupplierVO>> supplier = supplierApi.queryByCreditCode(noticeSupplierVO.getSupplierCreditCode());
                if(supplier.isSuccess() && CollectionUtils.isNotEmpty(supplier.getData())){
                    SupplierVO  supplierVO = supplier.getData().get(0);
                    noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
                    noticeSuplVO.setSupplierName(supplierVO.getName());
                    noticeSuplVO.setSupplierCreditCode(noticeSupplierVO.getSupplierCreditCode());
                }
                noticeSuplVO.setNoticeSuplProductEntities( BeanMapper.mapList(noticeSupplierVO.getNoticeProductEntities(), NoticeSuplProductVO.class) );
                logger.info("获取供方token--"+headers);
                CommonResponse<String> pushres = noticeService.pushNotice(headers, noticeSuplVO);
                logger.info("获取推送供方结果--"+pushres);
                logger.info("发送短信开始：通知供应商二次比价start：--" + C.ECXUN_NOTICE);
                String bizid = AliyunSMSUtil.sendSMSLogin1(C.ECXUN_NOTICE,
                                                           noticeSupplierVO.getSupplierContractPhone(),
                                                           noticeSupplierVO.getSupplierContractPerson(),
                                                           noticeSuplVO.getProjectName(),
                                                           noticeSuplVO.getMaterialTypeName(),
                                                           noticeSuplVO.getSubmitDeadline().toString());  // 通知供应商二次询价
                logger.info("发送短信结束：通知供应商二次比价end：--" + bizid);
                if(pushres.isSuccess()){
                    //推送成功后处理逻辑
                    noticeSupplierVO.setPushStatus(1);  // 已推送
//					noticeService.saveOrUpdate(noticeEntity,false);
                }else{
                    return pushres;
                }
            }
//			CompareEntity entity = BeanMapper.map(noticeEntity, CompareEntity.class);
        }else{
            return tokenres;
        }
		/*
		生成比价单
		 */
        CompareVO compareVO= compareService.generateCompareBill(noticeVO);
        compareService.saveOrUpdate(compareVO);
        return CommonResponse.success();
    }
    @Override
    public CommonResponse<NoticeVO> saveOrUpdate(NoticeVO saveOrUpdateVO) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        String operateType = null;
        Long oldSettingId = null;
        if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
            operateType = "add";
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(ECXJ_NOTICE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
            if(saveOrUpdateVO.getCropId() != null){
                //查询项目部上级组织的的来源id
                CommonResponse<OrgVO> orgVO = orgApi.getOneById(saveOrUpdateVO.getCropId());
                if(!orgVO.isSuccess()) {
                    throw new BusinessException("网络异常， 查询组织失败， 请稍后再试");
                }
                saveOrUpdateVO.setCropSourceId(orgVO.getData().getSourceId());
            }
            List<NoticeSupplierVO> ns = saveOrUpdateVO.getNoticeSupplierEntities();
            for (NoticeSupplierVO n : ns) {
                n.setSettingSupplierId(n.getId());   // 保存类型设置的供应商Id
                n.setPushStatus(0);                  // 设置供应商推送状态为0-未推送
                n.setId(null);
            }
        } else {
            oldSettingId = this.queryDetail(saveOrUpdateVO.getId()).getSettingId();
            if (oldSettingId != saveOrUpdateVO.getSettingId()) {
                Long noticeId = saveOrUpdateVO.getId();
                noticeSupplierService.remove(new QueryWrapper<NoticeSupplierEntity>().in("notice_id", noticeId));
                List<NoticeSupplierVO> ns = saveOrUpdateVO.getNoticeSupplierEntities();
                for (NoticeSupplierVO n : ns) {
                    n.setSettingSupplierId(n.getId());   // 保存类型设置的供应商Id
                    n.setId(null);
                }
            }
            operateType = "edit";
        }

        NoticeEntity entity = BeanMapper.map(saveOrUpdateVO, NoticeEntity.class);
        saveOrUpdate(entity, false);

        // 更改类型设置引用状态
        if ("add".equals(operateType)) {
            boolean flag = settingService.updateSettingStatus(entity.getSettingId().toString(), 1);
            if (!flag){
                throw new BusinessException("更改类型设置引用状态失败！");
            }
        } else {
            if (oldSettingId != null) {
                boolean oldFlag = settingService.updateSettingStatus(oldSettingId.toString(), 0);
                boolean flag = settingService.updateSettingStatus(entity.getSettingId().toString(), 1);
                if (!flag && !oldFlag){
                    throw new BusinessException("更改类型设置引用状态失败！");
                }
            }
            List<Long> sList = saveOrUpdateVO.getNoticeSupplierEntities().stream().map(NoticeSupplierVO::getId).collect(Collectors.toList());
            noticeProductService.remove(new QueryWrapper<NoticeProductEntity>().in("supplier_id", sList));
        }
        List<NoticeSupplierEntity> settingSupplierInfoEntities = entity.getNoticeSupplierEntities();  // 获取清单列表实体

        List<NoticeProductEntity> saveRedirects = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(settingSupplierInfoEntities)) {
            for (NoticeSupplierEntity info : settingSupplierInfoEntities) {
                List<NoticeProductEntity> list = info.getNoticeProductEntities();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (NoticeProductEntity re : list) {
                        re.setSupplierId(info.getId());
                        re.setSettingProductId(re.getId());    // 保存对应的设置类型的供应商Id
                        re.setId(null);
                        saveRedirects.add(re);
                    }
                }
            }
            noticeProductService.saveBatch(saveRedirects);
        }

//        saveOrUpdate(entity, false);
        NoticeVO vo = BeanMapper.map(entity, NoticeVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity entity = this.selectById(id);
        List<NoticeSupplierEntity> infoEntities = entity.getNoticeSupplierEntities();
        NoticeVO vo = BeanMapper.map(entity, NoticeVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List<NoticeSupplierVO> settingSupplierInfoVOS = BeanMapper.mapList(infoEntities, NoticeSupplierVO.class);
            QueryParam queryParam = null;
            for (NoticeSupplierVO infovo : settingSupplierInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("supplier_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<NoticeProductEntity> redirectEntities = noticeProductService.queryList(queryParam, false);
                infovo.setNoticeProductEntities(BeanMapper.mapList(redirectEntities, NoticeProductVO.class));
            }
            vo.setNoticeSupplierEntities(settingSupplierInfoVOS);
        }
        return vo;
    }

    @Override
    public boolean deleteNotice(List<NoticeVO> vos) {
        boolean flag = true;
        for (NoticeVO noticeVO : vos) {
            NoticeEntity entity = this.selectById(noticeVO.getId());
            flag = settingService.updateSettingStatus(entity.getSettingId().toString(), 0);
            if (!flag){
                throw new BusinessException("删除设置，更改类型设置引用状态失败！");
            }
        }
        super.removeByIds(vos.stream().map(NoticeVO::getId).collect(Collectors.toList()),true);
        return flag;
    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
//        headers.put("X-Token", "987b75e2727ae55289abd70d3f5864e6");
        if(redisTemplate.opsForValue().get("X-Open-Token") != null){
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------"+redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        }else{
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if("200".equals(json.get("code").toString())){
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                }else{
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushNotice(Map<String, String> headers,NoticeSuplVO noticeSuplVO){
        String url = wjNoticeUrl;
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(noticeSuplVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(noticeSuplVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送询价通知异常!");
        }
    }

    /**
     * 弃审删除供方二次填报单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushDelNotice(Map<String, String> headers,NoticeEntity noticeEntity){
        String url = wjDelNoticeUrl;
        String lightNoticeId = String.valueOf(noticeEntity.getId());
        Map<String,String> map = new HashMap<>();
        map.put("lightNoticeId",lightNoticeId);
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参lightNoticeId：" + lightNoticeId);
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.get(url, map, headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---删除Ecxj回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("删除二次询价填报单异常!");
        }
    }

}
