package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.injector.methods.SelectBatchByIds;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.SettingProductInfoEntity;
import com.ejianc.business.ecxj.bean.SettingSupplierInfoEntity;
import com.ejianc.business.ecxj.service.ISettingProductInfoService;
import com.ejianc.business.ecxj.service.ISettingSupplierInfoService;
import com.ejianc.business.ecxj.vo.SettingProductInfoVO;
import com.ejianc.business.ecxj.vo.SettingSupplierInfoVO;
import com.ejianc.business.ecxj.vo.TypeSettingVO;
import com.ejianc.business.ecxj.vo.YzwTenderVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ecxj.mapper.TypeSettingMapper;
import com.ejianc.business.ecxj.bean.TypeSettingEntity;
import com.ejianc.business.ecxj.service.ITypeSettingService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 集采类型设置
 * 
 * @author generator
 * 
 */
@Service("typeSettingService")
public class TypeSettingServiceImpl extends BaseServiceImpl<TypeSettingMapper, TypeSettingEntity> implements ITypeSettingService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettingProductInfoService settingProductInfoService;

    @Override
    @Transactional
    public CommonResponse<TypeSettingVO> saveOrUpdate(TypeSettingVO saveorUpdateVO) {
        logger.error("setting save json is " + JSONObject.toJSONString(saveorUpdateVO));
        TypeSettingEntity entity = BeanMapper.map(saveorUpdateVO, TypeSettingEntity.class);
        List<SettingSupplierInfoVO> supplierInfoList = baseMapper.getYzSupplierByTenderNo(entity.getTenderNo());
        entity.setSettingSupplierInfoEntities(BeanMapper.mapList(supplierInfoList, SettingSupplierInfoEntity.class));
        saveOrUpdate(entity, false);
        boolean flag = baseMapper.updateYzTendersStatus(entity.getTenderNo(), 1);
        if (!flag){
            throw new BusinessException("更改云筑网招标状态失败！");
        }

        List<SettingSupplierInfoEntity> settingSupplierInfoEntities = entity.getSettingSupplierInfoEntities();  // 获取清单列表实体
        for (SettingSupplierInfoEntity s : settingSupplierInfoEntities) {
            List<SettingProductInfoEntity> productInfoList = BeanMapper.mapList(baseMapper.getYzProductByTenderNo(s.getTendersNo(), s.getSupplierName()), SettingProductInfoEntity.class);
            List<SettingProductInfoEntity> saveRedirects = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(productInfoList)) {
                for (SettingProductInfoEntity re : productInfoList) {
                    re.setSupplierId(s.getId());
                    re.setId(null);
                    re.setCreateTime(null);
                    saveRedirects.add(re);
                }
            }
            settingProductInfoService.saveBatch(saveRedirects);
        }

//        saveOrUpdate(entity, false);         // 将Redirect存储到vo中，用于返回显示
        TypeSettingVO vo = BeanMapper.map(entity, TypeSettingVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public TypeSettingVO queryDetail(Long id) {
        TypeSettingEntity entity = this.selectById(id);
        List<SettingSupplierInfoEntity> infoEntities = entity.getSettingSupplierInfoEntities();
        TypeSettingVO vo = BeanMapper.map(entity, TypeSettingVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List<SettingSupplierInfoVO> settingSupplierInfoVOS = BeanMapper.mapList(infoEntities, SettingSupplierInfoVO.class);
            QueryParam queryParam = null;
            for (SettingSupplierInfoVO infovo : settingSupplierInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("supplier_id", new Parameter(QueryParam.EQ, infovo.getId()));
                List<SettingProductInfoEntity> redirectEntities = settingProductInfoService.queryList(queryParam, false);
                infovo.setSettingProductInfoEntities(BeanMapper.mapList(redirectEntities, SettingProductInfoVO.class));
                infovo.setNoticeProductEntities(BeanMapper.mapList(redirectEntities, SettingProductInfoVO.class));
            }
            vo.setSettingSupplierInfoEntities(settingSupplierInfoVOS);
            vo.setNoticeSupplierEntities(settingSupplierInfoVOS);
        }

        return vo;
    }

    @Override
    public boolean updateSettingStatus(String settingId, int isUsed) {
        return baseMapper.updateSettingStatus(settingId, isUsed);
    }

    @Override
    public boolean deleteSetting(List<TypeSettingVO> vos) {
        boolean flag = true;
        List<Long> removeIds = new ArrayList<>();
        List<Long> ids = vos.stream().map(TypeSettingVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<TypeSettingEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(TypeSettingEntity::getId, ids);
        List<TypeSettingEntity> settingEntities = list(queryWrapper);
        for (TypeSettingEntity s : settingEntities) {
            if (s.getIsUsed() == 0) {
                flag = baseMapper.updateYzTendersStatus(s.getTenderNo(), 0);
                if (!flag){
                    throw new BusinessException("删除设置，更改云筑网物资招标状态失败！");
                }
                removeIds.add(s.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(removeIds)) {
            super.removeByIds(removeIds, true);
        }
        return flag;
    }

    @Override
    public List<SettingSupplierInfoVO> getYzSupplier(String tenderNo) {
        return baseMapper.getYzSupplier(tenderNo);
    }

    @Override
    public List<YzwTenderVO> getYzTenderRef(Page<YzwTenderVO> page, QueryWrapper wrapper, Long tenantid) {
        List<YzwTenderVO> list = baseMapper.getYzTenderRef(page, wrapper,tenantid);
        return list;
    }
}
