package com.ejianc.business.ecxj.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 比选报价供应商实体（类似转扣）
 * 
 * @author generator
 * 
 */
public class CompareSupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long compareId; // 询价单主表主键ID
    private Long tenderSupplierId; // 云筑供应商Id
    private String supplierName; // 供应商名称
    private String supplierCreditCode; // 供应商纳税人编号

    private String supplierContractPerson; // 中标供应商联系人
    private String supplierContractPhone; // 中标供应商联系方式
    private BigDecimal sumMny; // 物资累计金额
    private Integer pushStatus; // 报价状态，0-未推送，1-已推送

    private List<CompareProductVO> compareProductEntities = new ArrayList<>(); // 比价物资中的供应商清单实体（子表）
    private List<FileVO> fileList = new ArrayList<>(); // 二次询价附件列表

    public Long getCompareId() {
        return compareId;
    }

    public void setCompareId(Long compareId) {
        this.compareId = compareId;
    }
    public Long getTenderSupplierId() {
        return tenderSupplierId;
    }

    public void setTenderSupplierId(Long tenderSupplierId) {
        this.tenderSupplierId = tenderSupplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }
    public String getSupplierContractPerson() {
        return supplierContractPerson;
    }

    public void setSupplierContractPerson(String supplierContractPerson) {
        this.supplierContractPerson = supplierContractPerson;
    }
    public String getSupplierContractPhone() {
        return supplierContractPhone;
    }

    public void setSupplierContractPhone(String supplierContractPhone) {
        this.supplierContractPhone = supplierContractPhone;
    }
    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }
    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }

    public List<CompareProductVO> getCompareProductEntities() {
        return compareProductEntities;
    }

    public void setCompareProductEntities(List<CompareProductVO> compareProductEntities) {
        this.compareProductEntities = compareProductEntities;
    }

    public List<FileVO> getFileList() {
        return fileList;
    }

    public void setFileList(List<FileVO> fileList) {
        this.fileList = fileList;
    }
}
