/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierTenderEntity;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import com.ejianc.business.ecxj.mapper.AnalysisMapper;
import com.ejianc.business.ecxj.service.IAnalysisService;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.ICompareSupplierTenderService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.business.ecxj.vo.CompareSupplierTenderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="analysisService")
public class AnalysisServiceImpl
extends BaseServiceImpl<AnalysisMapper, CompareEntity>
implements IAnalysisService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierTenderService compareSupplierTenderService;

    @Override
    public AnalysisVO getNum() {
        ArrayList commonOrgIds = new ArrayList();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        AnalysisVO analysisVO = new AnalysisVO();
        LambdaQueryWrapper lambda1 = Wrappers.lambdaQuery();
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda1.in(NoticeEntity::getOrgId, commonOrgIds);
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List noticeEntities = this.noticeService.list((Wrapper)lambda1);
        List compareEntities = this.compareService.list((Wrapper)lambda2);
        BigDecimal projectNum = BigDecimal.ZERO;
        BigDecimal compareNum = BigDecimal.ZERO;
        List compareIds = null;
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            List projectIds = noticeEntities.stream().map(NoticeEntity::getProjectId).distinct().collect(Collectors.toList());
            compareIds = compareEntities.stream().map(CompareEntity::getProjectId).distinct().collect(Collectors.toList());
            long count = projectIds.stream().count();
            projectNum = BigDecimal.valueOf(count);
            compareNum = BigDecimal.valueOf(compareEntities.size());
        }
        analysisVO.setProjectNum(projectNum);
        analysisVO.setProjectNum(compareNum);
        BigDecimal tenderNum = BigDecimal.ZERO;
        BigDecimal moneyNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(compareIds)) {
            LambdaQueryWrapper lambdaTender = Wrappers.lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List cstList = this.compareSupplierTenderService.list((Wrapper)lambdaTender);
            if (CollectionUtils.isNotEmpty((Collection)cstList)) {
                tenderNum = cstList.stream().map(CompareSupplierTenderEntity::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                moneyNum = BigDecimal.valueOf(cstList.size());
            }
        }
        analysisVO.setTenderNum(tenderNum);
        analysisVO.setMoneyNum(moneyNum);
        return analysisVO;
    }

    @Override
    public List<AnalysisVO> getPeriodMoney() {
        ArrayList commonOrgIds = new ArrayList();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ArrayList<AnalysisVO> analysisList = new ArrayList<AnalysisVO>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List compareEntities = this.compareService.list((Wrapper)lambda2);
        List compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<Object, Object> periodMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            compareIds = compareEntities.stream().map(CompareEntity::getProjectId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper lambdaTender = Wrappers.lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List cstList = this.compareSupplierTenderService.list((Wrapper)lambdaTender);
            if (CollectionUtils.isNotEmpty((Collection)cstList)) {
                List cstVOList = BeanMapper.mapList((Iterable)cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }
        for (int i = 6; i > 0; --i) {
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setPeriod(period);
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            if (periodMap.containsKey(period)) {
                List supplierTenderVOList = (List)periodMap.get(period);
                moneyTaxNum = supplierTenderVOList.stream().map(CompareSupplierTenderVO::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                analysisVO.setMoneyNum(moneyTaxNum);
            }
            analysisList.add(analysisVO);
            calendar.add(2, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> getPeriodCs() {
        ArrayList commonOrgIds = new ArrayList();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ArrayList<AnalysisVO> analysisList = new ArrayList<AnalysisVO>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List compareEntities = this.compareService.list((Wrapper)lambda2);
        List compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<Object, Object> periodMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            compareIds = compareEntities.stream().map(CompareEntity::getProjectId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper lambdaTender = Wrappers.lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List cstList = this.compareSupplierTenderService.list((Wrapper)lambdaTender);
            if (CollectionUtils.isNotEmpty((Collection)cstList)) {
                List cstVOList = BeanMapper.mapList((Iterable)cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }
        for (int i = 6; i > 0; --i) {
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            analysisVO.setPeriod(period);
            if (periodMap.containsKey(period)) {
                List csTenderVOList = (List)periodMap.get(period);
                analysisVO.setFrequency(csTenderVOList.size());
            }
            analysisList.add(analysisVO);
            calendar.add(2, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> queryDetailsList() {
        QueryParam param = new QueryParam();
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = AnalysisServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AnalysisVO> list = ((AnalysisMapper)this.baseMapper).queryDetailsList((Page<AnalysisVO>)page, wrapper);
        return list;
    }
}

