/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.CompareProductEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierEntity;
import com.ejianc.business.ecxj.bean.FileEntity;
import com.ejianc.business.ecxj.mapper.CompareMapper;
import com.ejianc.business.ecxj.service.ICompareProductService;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.ICompareSupplierService;
import com.ejianc.business.ecxj.service.IFileService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.util.HttpTookit;
import com.ejianc.business.ecxj.vo.CompareProductVO;
import com.ejianc.business.ecxj.vo.CompareSupplierVO;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.business.ecxj.vo.FileVO;
import com.ejianc.business.ecxj.vo.NoticeSuplProductVO;
import com.ejianc.business.ecxj.vo.NoticeSuplVO;
import com.ejianc.business.ecxj.vo.NoticeSupplierVO;
import com.ejianc.business.ecxj.vo.NoticeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="compareService")
public class CompareServiceImpl
extends BaseServiceImpl<CompareMapper, CompareEntity>
implements ICompareService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ECXJ_COMPARE_BILL_CODE = "ECXJ_COMPARE_BILL_CODE";
    @Value(value="${openApi.wjNoticePostDeadlineUrl}")
    private String wjNoticePostDeadlineUrl;
    @Value(value="${img.serverPath}")
    private String serverPath;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IFileService fileService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierService compareSupplierService;
    @Autowired
    private ICompareProductService compareProductService;

    @Override
    public CompareVO generateCompareBill(NoticeVO noticeEntity) {
        CompareVO compareVO = new CompareVO();
        compareVO.setNoticeId(noticeEntity.getId());
        compareVO.setProjectId(noticeEntity.getProjectId());
        compareVO.setProjectName(noticeEntity.getProjectName());
        compareVO.setProjectSourceId(noticeEntity.getProjectSourceId());
        compareVO.setCropId(noticeEntity.getCropId());
        compareVO.setCropName(noticeEntity.getCropName());
        compareVO.setCropSourceId(noticeEntity.getCropSourceId());
        compareVO.setRealCorpId(noticeEntity.getRealCorpId());
        compareVO.setRealCorpName(noticeEntity.getRealCorpName());
        compareVO.setRealNcCorp(noticeEntity.getRealNcCorp());
        compareVO.setOrgId(noticeEntity.getOrgId());
        compareVO.setOrgName(noticeEntity.getOrgName());
        compareVO.setOrgSourceId(noticeEntity.getOrgSourceId());
        compareVO.setMaterialTypeId(noticeEntity.getMaterialTypeId());
        compareVO.setMaterialTypeName(noticeEntity.getMaterialTypeName());
        compareVO.setOrgSourceId(noticeEntity.getOrgSourceId());
        compareVO.setSubmitDeadline(noticeEntity.getSubmitDeadline());
        compareVO.setCompareTime(noticeEntity.getCompareTime());
        compareVO.setSettingId(noticeEntity.getSettingId());
        compareVO.setTenderId(noticeEntity.getTenderId());
        compareVO.setTenderNo(noticeEntity.getTenderNo());
        compareVO.setTenderName(noticeEntity.getTenderName());
        compareVO.setQuoteType(noticeEntity.getQuoteType());
        compareVO.setCompareStatus(0);
        compareVO.setNotification(noticeEntity.getNotification());
        List<NoticeSupplierVO> noticeSupplierVOS = noticeEntity.getNoticeSupplierEntities();
        for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
            noticeSupplierVO.setId(null);
            noticeSupplierVO.setPushStatus(0);
            noticeSupplierVO.setPushStatus(null);
            noticeSupplierVO.setCreateTime(null);
            noticeSupplierVO.setUpdateUserCode(null);
            noticeSupplierVO.setUpdateTime(null);
        }
        List compareSupplierVOS = BeanMapper.mapList(noticeSupplierVOS, CompareSupplierVO.class);
        for (CompareSupplierVO c : compareSupplierVOS) {
            for (NoticeSupplierVO n : noticeSupplierVOS) {
                if (!c.getSupplierCreditCode().equals(n.getSupplierCreditCode())) continue;
                List compareProductVOS = BeanMapper.mapList(n.getNoticeProductEntities(), CompareProductVO.class);
                for (CompareProductVO cp : compareProductVOS) {
                    cp.setCreateTime(null);
                    cp.setUpdateUserCode(null);
                    cp.setUpdateTime(null);
                }
                c.setCompareProductEntities(compareProductVOS);
            }
        }
        compareVO.setCompareSupplierEntities(compareSupplierVOS);
        return compareVO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<CompareVO> saveOrUpdate(CompareVO saveOrUpdateVO) {
        CommonResponse orgParentVo = this.orgApi.getOneById(saveOrUpdateVO.getOrgId());
        if (!orgParentVo.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u8be6\u60c5\u5931\u8d25\uff01");
        }
        String operateType = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
            operateType = "add";
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ECXJ_COMPARE_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            saveOrUpdateVO.setBillCode((String)billCode.getData());
        } else {
            operateType = "edit";
        }
        CompareEntity entity = (CompareEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), CompareEntity.class));
        this.saveOrUpdate((Object)entity, false);
        if (entity.getCompareStatus() != null && entity.getCompareStatus() == 2) {
            CompareVO vo = (CompareVO)((Object)BeanMapper.map((Object)((Object)entity), CompareVO.class));
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
        }
        List<CompareSupplierEntity> compareSupplierEntities = entity.getCompareSupplierEntities();
        if ("edit".equals(operateType)) {
            List sList = saveOrUpdateVO.getCompareSupplierEntities().stream().map(BaseVO::getId).collect(Collectors.toList());
            this.compareProductService.remove((Wrapper)new QueryWrapper().in((Object)"supplier_id", sList));
        }
        ArrayList<CompareProductEntity> saveRedirects = new ArrayList<CompareProductEntity>();
        if (CollectionUtils.isNotEmpty(compareSupplierEntities)) {
            for (CompareSupplierEntity info : compareSupplierEntities) {
                List<CompareProductEntity> list = info.getCompareProductEntities();
                if (!CollectionUtils.isNotEmpty(list)) continue;
                for (CompareProductEntity re : list) {
                    re.setSupplierId(info.getId());
                    re.setId(null);
                    saveRedirects.add(re);
                }
            }
            this.compareProductService.saveBatch(saveRedirects);
        }
        CompareVO vo = (CompareVO)((Object)BeanMapper.map((Object)((Object)entity), CompareVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CompareVO queryDetail(Long id) {
        CompareEntity entity = (CompareEntity)((Object)this.selectById(id));
        List<CompareSupplierEntity> infoEntities = entity.getCompareSupplierEntities();
        CompareVO vo = (CompareVO)((Object)BeanMapper.map((Object)((Object)entity), CompareVO.class));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowDateTime = sdf.format(new Date());
        String compareTime = sdf.format(entity.getCompareTime());
        Integer overTimeFlag = nowDateTime.compareTo(compareTime);
        if (infoEntities != null && infoEntities.size() > 0) {
            List settingSupplierInfoVOS = BeanMapper.mapList(infoEntities, CompareSupplierVO.class);
            QueryParam queryParam = null;
            QueryParam queryParam1 = null;
            for (CompareSupplierVO infovo : settingSupplierInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)infovo.getId()));
                List redirectEntities = this.compareProductService.queryList(queryParam, false);
                infovo.setCompareProductEntities(BeanMapper.mapList((Iterable)redirectEntities, CompareProductVO.class));
                if (overTimeFlag > 0) {
                    queryParam1 = new QueryParam();
                    queryParam1.getParams().put("supplier_id", new Parameter("eq", (Object)infovo.getId()));
                    List fileEntities = this.fileService.queryList(queryParam1, false);
                    infovo.setFileList(BeanMapper.mapList((Iterable)fileEntities, FileVO.class));
                    continue;
                }
                infovo.setFileList(null);
            }
            vo.setCompareSupplierEntities(settingSupplierInfoVOS);
        }
        return vo;
    }

    @Override
    public CompareVO updateCompare(NoticeSuplVO noticeSuplVO) {
        Integer submitStatus = noticeSuplVO.getSubmitStatus();
        String supplierCreditCode = noticeSuplVO.getSupplierCreditCode();
        Long lightNoticeId = noticeSuplVO.getLightNoticeId();
        BigDecimal sumMny = noticeSuplVO.getSumMny();
        List<NoticeSuplProductVO> noticeSuplProductEntities = noticeSuplVO.getNoticeSuplProductEntities();
        List<FileVO> fileVOList = noticeSuplVO.getFileList();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CompareEntity::getNoticeId, (Object)lightNoticeId);
        CompareEntity compareEntity = (CompareEntity)((Object)this.compareService.getOne((Wrapper)queryWrapper));
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(CompareSupplierEntity::getCompareId, (Object)compareEntity.getId());
        lambda2.eq(CompareSupplierEntity::getSupplierCreditCode, (Object)supplierCreditCode);
        List compareSupplierEntities = this.compareSupplierService.list((Wrapper)lambda2);
        compareEntity.setCompareSupplierEntities(compareSupplierEntities);
        for (CompareSupplierEntity c : compareSupplierEntities) {
            if (!c.getSupplierCreditCode().equals(supplierCreditCode)) continue;
            if (submitStatus == 3) {
                c.setPushStatus(2);
                this.saveOrUpdate((Object)compareEntity, false);
                CompareVO compareVO = (CompareVO)((Object)BeanMapper.map((Object)((Object)compareEntity), CompareVO.class));
                return compareVO;
            }
            LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
            lambda3.eq(CompareProductEntity::getSupplierId, (Object)c.getId());
            List compareProductEntities = this.compareProductService.list((Wrapper)lambda3);
            for (CompareProductEntity cp : compareProductEntities) {
                for (NoticeSuplProductVO nsp : noticeSuplProductEntities) {
                    if (!cp.getTenderProductId().equals(nsp.getTenderProductId())) continue;
                    cp.setFillPrice(nsp.getFillPrice());
                }
            }
            c.setCompareProductEntities(compareProductEntities);
            c.setPushStatus(1);
            c.setSumMny(sumMny);
            if (!CollectionUtils.isNotEmpty(fileVOList) || fileVOList.size() == 0) continue;
            this.saveFile(fileVOList, c.getId());
            List fileEntities = BeanMapper.mapList(fileVOList, FileEntity.class);
            c.setFileList(fileEntities);
        }
        compareEntity.setCompareSupplierEntities(compareSupplierEntities);
        CompareVO compareVO = (CompareVO)((Object)BeanMapper.map((Object)((Object)compareEntity), CompareVO.class));
        this.saveOrUpdate(compareVO);
        return compareVO;
    }

    public boolean saveFile(List<FileVO> fileVOList, Long id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(FileEntity::getSupplierId, (Object)id);
        this.fileService.remove((Wrapper)queryWrapper);
        for (FileVO f : fileVOList) {
            f.setSupplierId(id);
        }
        List fileEntities = BeanMapper.mapList(fileVOList, FileEntity.class);
        return this.fileService.saveBatch(fileEntities);
    }

    @Override
    public boolean deleteCompare(List<CompareVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        boolean flag = true;
        return flag;
    }

    @Override
    public CompareVO submit(CompareVO vo) {
        this.saveOrUpdate(vo);
        return vo;
    }

    @Override
    @Transactional
    public CommonResponse<String> postDeadline(CompareVO vo) {
        this.saveOrUpdate(vo);
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.noticeService.getAccessToken(headers);
        Long noticeId = vo.getNoticeId();
        NoticeVO noticeVO = this.noticeService.queryDetail(noticeId);
        noticeVO.setSubmitDeadline(vo.getSubmitDeadline());
        NoticeSuplVO noticeSuplVO = (NoticeSuplVO)BeanMapper.map((Object)((Object)noticeVO), NoticeSuplVO.class);
        if (tokenres.isSuccess()) {
            List<NoticeSupplierVO> noticeSupplierVOS = noticeVO.getNoticeSupplierEntities();
            for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
                CommonResponse supplier = this.supplierApi.queryByCreditCode(noticeSupplierVO.getSupplierCreditCode());
                if (supplier.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)supplier.getData()))) {
                    SupplierVO supplierVO = (SupplierVO)((List)supplier.getData()).get(0);
                    noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
                    noticeSuplVO.setSupplierName(supplierVO.getName());
                    noticeSuplVO.setSupplierCreditCode(supplierVO.getSocialCreditCode());
                }
                this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
                CommonResponse<String> pushres = this.pushNoticePostDeadline(headers, noticeSuplVO);
                this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
                if (pushres.isSuccess()) {
                    this.logger.info("\u63a8\u8fdf\u65f6\u95f4\u6210\u529f\uff01");
                    continue;
                }
                return pushres;
            }
            return CommonResponse.success((String)"\u63a8\u8fdf\u65f6\u95f4\u6210\u529f\uff01");
        }
        return tokenres;
    }

    public CommonResponse<String> pushNoticePostDeadline(Map<String, String> headers, NoticeSuplVO noticeSuplVO) {
        String url = this.wjNoticePostDeadlineUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)noticeSuplVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)noticeSuplVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u8be2\u4ef7\u901a\u77e5\u5f02\u5e38!");
        }
    }
}

