/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import com.ejianc.business.ecxj.bean.NoticeProductEntity;
import com.ejianc.business.ecxj.bean.NoticeSupplierEntity;
import com.ejianc.business.ecxj.mapper.NoticeMapper;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.INoticeProductService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.service.INoticeSupplierService;
import com.ejianc.business.ecxj.service.ITypeSettingService;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.util.HttpTookit;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.business.ecxj.vo.NoticeProductVO;
import com.ejianc.business.ecxj.vo.NoticeSuplProductVO;
import com.ejianc.business.ecxj.vo.NoticeSuplVO;
import com.ejianc.business.ecxj.vo.NoticeSupplierVO;
import com.ejianc.business.ecxj.vo.NoticeVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="noticeService")
public class NoticeServiceImpl
extends BaseServiceImpl<NoticeMapper, NoticeEntity>
implements INoticeService {
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.wjNoticeUrl}")
    private String wjNoticeUrl;
    @Value(value="${openApi.wjDelNoticeUrl}")
    private String wjDelNoticeUrl;
    private static final String ECXJ_NOTICE_BILL_CODE = "CSCEC5B_ECXJ_NOTICE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ITypeSettingService settingService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private INoticeSupplierService noticeSupplierService;
    @Autowired
    private INoticeProductService noticeProductService;
    @Autowired
    private ISupplierApi supplierApi;

    @Override
    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        NoticeVO noticeVO = this.noticeService.queryDetail(billId);
        NoticeSuplVO noticeSuplVO = (NoticeSuplVO)BeanMapper.map((Object)((Object)noticeVO), NoticeSuplVO.class);
        String yzTenderNo = noticeVO.getTenderNo();
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.noticeService.getAccessToken(headers);
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token  tokenres.isSuccess() --" + tokenres.isSuccess());
        if (tokenres.isSuccess()) {
            List<NoticeSupplierVO> noticeSupplierVOS = noticeVO.getNoticeSupplierEntities();
            for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
                CommonResponse supplier = this.supplierApi.queryByCreditCode(noticeSupplierVO.getSupplierCreditCode());
                if (supplier.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)supplier.getData()))) {
                    SupplierVO supplierVO = (SupplierVO)((List)supplier.getData()).get(0);
                    noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
                    noticeSuplVO.setSupplierName(supplierVO.getName());
                    noticeSuplVO.setSupplierCreditCode(noticeSupplierVO.getSupplierCreditCode());
                }
                noticeSuplVO.setNoticeSuplProductEntities(BeanMapper.mapList(noticeSupplierVO.getNoticeProductEntities(), NoticeSuplProductVO.class));
                this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
                CommonResponse<String> pushres = this.noticeService.pushNotice(headers, noticeSuplVO);
                this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
                this.logger.info("\u53d1\u9001\u77ed\u4fe1\u5f00\u59cb\uff1a\u901a\u77e5\u4f9b\u5e94\u5546\u4e8c\u6b21\u6bd4\u4ef7start\uff1a--NOTICE");
                String bizid = AliyunSMSUtil.sendSMSLogin1("NOTICE", noticeSupplierVO.getSupplierContractPhone(), noticeSupplierVO.getSupplierContractPerson(), noticeSuplVO.getProjectName(), noticeSuplVO.getMaterialTypeName(), noticeSuplVO.getSubmitDeadline().toString());
                this.logger.info("\u53d1\u9001\u77ed\u4fe1\u7ed3\u675f\uff1a\u901a\u77e5\u4f9b\u5e94\u5546\u4e8c\u6b21\u6bd4\u4ef7end\uff1a--" + bizid);
                if (pushres.isSuccess()) {
                    noticeSupplierVO.setPushStatus(1);
                    continue;
                }
                return pushres;
            }
        } else {
            return tokenres;
        }
        CompareVO compareVO = this.compareService.generateCompareBill(noticeVO);
        this.compareService.saveOrUpdate(compareVO);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<NoticeVO> saveOrUpdate(NoticeVO saveOrUpdateVO) {
        List<NoticeSupplierVO> ns;
        Long tenantId = InvocationInfoProxy.getTenantid();
        String operateType = null;
        Long oldSettingId = null;
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
            operateType = "add";
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ECXJ_NOTICE_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            saveOrUpdateVO.setBillCode((String)billCode.getData());
            if (saveOrUpdateVO.getCropId() != null) {
                CommonResponse orgVO = this.orgApi.getOneById(saveOrUpdateVO.getCropId());
                if (!orgVO.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                saveOrUpdateVO.setCropSourceId(((OrgVO)orgVO.getData()).getSourceId());
            }
            ns = saveOrUpdateVO.getNoticeSupplierEntities();
            for (NoticeSupplierVO noticeSupplierVO : ns) {
                noticeSupplierVO.setSettingSupplierId(noticeSupplierVO.getId());
                noticeSupplierVO.setPushStatus(0);
                noticeSupplierVO.setId(null);
            }
        } else {
            oldSettingId = this.queryDetail(saveOrUpdateVO.getId()).getSettingId();
            if (oldSettingId != saveOrUpdateVO.getSettingId()) {
                Long noticeId = saveOrUpdateVO.getId();
                this.noticeSupplierService.remove((Wrapper)new QueryWrapper().in((Object)"notice_id", new Object[]{noticeId}));
                ns = saveOrUpdateVO.getNoticeSupplierEntities();
                for (NoticeSupplierVO noticeSupplierVO : ns) {
                    noticeSupplierVO.setSettingSupplierId(noticeSupplierVO.getId());
                    noticeSupplierVO.setId(null);
                }
            }
            operateType = "edit";
        }
        NoticeEntity entity = (NoticeEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), NoticeEntity.class));
        this.saveOrUpdate((Object)entity, false);
        if ("add".equals(operateType)) {
            boolean flag = this.settingService.updateSettingStatus(entity.getSettingId().toString(), 1);
            if (!flag) {
                throw new BusinessException("\u66f4\u6539\u7c7b\u578b\u8bbe\u7f6e\u5f15\u7528\u72b6\u6001\u5931\u8d25\uff01");
            }
        } else {
            if (oldSettingId != null) {
                boolean oldFlag = this.settingService.updateSettingStatus(oldSettingId.toString(), 0);
                boolean flag = this.settingService.updateSettingStatus(entity.getSettingId().toString(), 1);
                if (!flag && !oldFlag) {
                    throw new BusinessException("\u66f4\u6539\u7c7b\u578b\u8bbe\u7f6e\u5f15\u7528\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
            List sList = saveOrUpdateVO.getNoticeSupplierEntities().stream().map(BaseVO::getId).collect(Collectors.toList());
            this.noticeProductService.remove((Wrapper)new QueryWrapper().in((Object)"supplier_id", sList));
        }
        List<NoticeSupplierEntity> settingSupplierInfoEntities = entity.getNoticeSupplierEntities();
        ArrayList<NoticeProductEntity> saveRedirects = new ArrayList<NoticeProductEntity>();
        if (CollectionUtils.isNotEmpty(settingSupplierInfoEntities)) {
            for (NoticeSupplierEntity info : settingSupplierInfoEntities) {
                List<NoticeProductEntity> list = info.getNoticeProductEntities();
                if (!CollectionUtils.isNotEmpty(list)) continue;
                for (NoticeProductEntity re : list) {
                    re.setSupplierId(info.getId());
                    re.setSettingProductId(re.getId());
                    re.setId(null);
                    saveRedirects.add(re);
                }
            }
            this.noticeProductService.saveBatch(saveRedirects);
        }
        NoticeVO noticeVO = (NoticeVO)((Object)BeanMapper.map((Object)((Object)entity), NoticeVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)noticeVO));
    }

    @Override
    public NoticeVO queryDetail(Long id) {
        NoticeEntity entity = (NoticeEntity)((Object)this.selectById(id));
        List<NoticeSupplierEntity> infoEntities = entity.getNoticeSupplierEntities();
        NoticeVO vo = (NoticeVO)((Object)BeanMapper.map((Object)((Object)entity), NoticeVO.class));
        if (infoEntities != null && infoEntities.size() > 0) {
            List settingSupplierInfoVOS = BeanMapper.mapList(infoEntities, NoticeSupplierVO.class);
            QueryParam queryParam = null;
            for (NoticeSupplierVO infovo : settingSupplierInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)infovo.getId()));
                List redirectEntities = this.noticeProductService.queryList(queryParam, false);
                infovo.setNoticeProductEntities(BeanMapper.mapList((Iterable)redirectEntities, NoticeProductVO.class));
            }
            vo.setNoticeSupplierEntities(settingSupplierInfoVOS);
        }
        return vo;
    }

    @Override
    public boolean deleteNotice(List<NoticeVO> vos) {
        boolean flag = true;
        for (NoticeVO noticeVO : vos) {
            NoticeEntity entity = (NoticeEntity)((Object)this.selectById(noticeVO.getId()));
            flag = this.settingService.updateSettingStatus(entity.getSettingId().toString(), 0);
            if (flag) continue;
            throw new BusinessException("\u5220\u9664\u8bbe\u7f6e\uff0c\u66f4\u6539\u7c7b\u578b\u8bbe\u7f6e\u5f15\u7528\u72b6\u6001\u5931\u8d25\uff01");
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return flag;
    }

    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> pushNotice(Map<String, String> headers, NoticeSuplVO noticeSuplVO) {
        String url = this.wjNoticeUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)noticeSuplVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)noticeSuplVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u8be2\u4ef7\u901a\u77e5\u5f02\u5e38!");
        }
    }

    @Override
    public CommonResponse<String> pushDelNotice(Map<String, String> headers, NoticeEntity noticeEntity) {
        String url = this.wjDelNoticeUrl;
        String lightNoticeId = String.valueOf(noticeEntity.getId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("lightNoticeId", lightNoticeId);
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2lightNoticeId\uff1a" + lightNoticeId);
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.get(url, map, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u5220\u9664Ecxj\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u5220\u9664\u4e8c\u6b21\u8be2\u4ef7\u586b\u62a5\u5355\u5f02\u5e38!");
        }
    }
}

