/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.vo.CompareSupplierTenderVO;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="compare")
public class CompareBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICompareService compareService;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(CompareEntity::getCompareStatus, (Object)0);
        Wrappers.update((Object)updateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff01---------------------------");
        this.logger.info("---------------------------baseHost\uff01---------------------------" + this.baseHost + "---------------------------------");
        CompareVO vo = this.compareService.queryDetail(billId);
        String corpName = vo.getCropName();
        String projectName = vo.getProjectName();
        String materialTypeName = vo.getMaterialTypeName();
        List<CompareSupplierTenderVO> compareSupplierTenderVOS = vo.getCompareSupplierTenderEntities();
        for (CompareSupplierTenderVO c : compareSupplierTenderVOS) {
            String linkman = c.getSupplierContractPerson();
            String phone = c.getSupplierContractPhone();
            String string = AliyunSMSUtil.sendSMSLogin1("TENDER", phone, linkman, projectName, materialTypeName, corpName);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(CompareEntity::getCompareStatus, (Object)0);
        Wrappers.update((Object)updateWrapper);
        return CommonResponse.success();
    }
}

