/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierEntity;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.business.ecxj.vo.NoticeSuplProductVO;
import com.ejianc.business.ecxj.vo.NoticeSuplVO;
import com.ejianc.business.ecxj.vo.NoticeSupplierVO;
import com.ejianc.business.ecxj.vo.NoticeVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="notice")
public class NoticeBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff01---------------------------");
        this.logger.info("---------------------------baseHost\uff01---------------------------" + this.baseHost + "---------------------------------");
        NoticeVO noticeVO = this.noticeService.queryDetail(billId);
        NoticeSuplVO noticeSuplVO = (NoticeSuplVO)BeanMapper.map((Object)((Object)noticeVO), NoticeSuplVO.class);
        String yzTenderNo = noticeVO.getTenderNo();
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.noticeService.getAccessToken(headers);
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token  tokenres.isSuccess() --" + tokenres.isSuccess());
        if (tokenres.isSuccess()) {
            List<NoticeSupplierVO> noticeSupplierVOS = noticeVO.getNoticeSupplierEntities();
            for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
                CommonResponse supplier = this.supplierApi.queryByCreditCode(noticeSupplierVO.getSupplierCreditCode());
                if (supplier.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)supplier.getData()))) {
                    SupplierVO supplierVO = (SupplierVO)((List)supplier.getData()).get(0);
                    noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
                    noticeSuplVO.setSupplierName(supplierVO.getName());
                    noticeSuplVO.setSupplierCreditCode(supplierVO.getSocialCreditCode());
                }
                noticeSuplVO.setNoticeSuplProductEntities(BeanMapper.mapList(noticeSupplierVO.getNoticeProductEntities(), NoticeSuplProductVO.class));
                this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
                CommonResponse<String> pushres = this.noticeService.pushNotice(headers, noticeSuplVO);
                this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
                this.logger.info("\u53d1\u9001\u77ed\u4fe1\u5f00\u59cb\uff1a\u901a\u77e5\u4f9b\u5e94\u5546\u4e8c\u6b21\u6bd4\u4ef7start\uff1a--NOTICE");
                String bizid = AliyunSMSUtil.sendSMSLogin1("NOTICE", noticeSupplierVO.getSupplierContractPhone(), noticeSupplierVO.getSupplierContractPerson(), noticeSuplVO.getProjectName(), noticeSuplVO.getMaterialTypeName(), noticeSuplVO.getSubmitDeadline().toString());
                this.logger.info("\u53d1\u9001\u77ed\u4fe1\u7ed3\u675f\uff1a\u901a\u77e5\u4f9b\u5e94\u5546\u4e8c\u6b21\u6bd4\u4ef7end\uff1a--" + bizid);
                if (pushres.isSuccess()) {
                    noticeSupplierVO.setPushStatus(1);
                    continue;
                }
                return pushres;
            }
        } else {
            return tokenres;
        }
        CompareVO compareVO = this.compareService.generateCompareBill(noticeVO);
        this.compareService.saveOrUpdate(compareVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CompareEntity::getNoticeId, (Object)billId);
        CompareEntity compareEntity = (CompareEntity)((Object)this.compareService.getOne((Wrapper)queryWrapper));
        CompareEntity compareEntity1 = (CompareEntity)((Object)this.compareService.selectById(compareEntity.getId()));
        List<CompareSupplierEntity> compareSupplierEntities = compareEntity1.getCompareSupplierEntities();
        for (CompareSupplierEntity s : compareSupplierEntities) {
            if (s.getPushStatus() == null || s.getPushStatus() != 1) continue;
            return CommonResponse.error((String)"\u8be5\u901a\u77e5\u5355\u5df2\u88ab\u4f9b\u65b9\u63d0\u4ea4\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        return CommonResponse.success();
    }

    @Transactional
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(CompareEntity::getNoticeId, (Object)billId);
        CompareEntity compareEntity = (CompareEntity)((Object)this.compareService.getOne((Wrapper)queryWrapper));
        ArrayList<CompareVO> compareList = new ArrayList<CompareVO>();
        compareList.add((CompareVO)((Object)BeanMapper.map((Object)((Object)compareEntity), CompareVO.class)));
        boolean flag = this.compareService.deleteCompare(compareList);
        HashMap<String, String> headers = new HashMap<String, String>();
        NoticeEntity noticeEntity = (NoticeEntity)((Object)this.noticeService.selectById(billId));
        CommonResponse<String> tokenres = this.noticeService.getAccessToken(headers);
        if (!tokenres.isSuccess()) {
            return CommonResponse.error((String)"\u8c03\u7528\u4f9b\u65b9\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
        CommonResponse<String> pushres = this.noticeService.pushDelNotice(headers, noticeEntity);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
        return CommonResponse.success();
    }
}

