/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.SettingProductInfoEntity;
import com.ejianc.business.ecxj.bean.SettingSupplierInfoEntity;
import com.ejianc.business.ecxj.bean.TypeSettingEntity;
import com.ejianc.business.ecxj.mapper.TypeSettingMapper;
import com.ejianc.business.ecxj.service.ISettingProductInfoService;
import com.ejianc.business.ecxj.service.ITypeSettingService;
import com.ejianc.business.ecxj.vo.SettingProductInfoVO;
import com.ejianc.business.ecxj.vo.SettingSupplierInfoVO;
import com.ejianc.business.ecxj.vo.TypeSettingVO;
import com.ejianc.business.ecxj.vo.YzwTenderVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="typeSettingService")
public class TypeSettingServiceImpl
extends BaseServiceImpl<TypeSettingMapper, TypeSettingEntity>
implements ITypeSettingService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettingProductInfoService settingProductInfoService;

    @Override
    @Transactional
    public CommonResponse<TypeSettingVO> saveOrUpdate(TypeSettingVO saveorUpdateVO) {
        this.logger.error("setting save json is " + JSONObject.toJSONString((Object)((Object)saveorUpdateVO)));
        TypeSettingEntity entity = (TypeSettingEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), TypeSettingEntity.class));
        List<SettingSupplierInfoVO> supplierInfoList = ((TypeSettingMapper)this.baseMapper).getYzSupplierByTenderNo(entity.getTenderNo(), entity.getProductType());
        entity.setSettingSupplierInfoEntities(BeanMapper.mapList(supplierInfoList, SettingSupplierInfoEntity.class));
        this.saveOrUpdate((Object)entity, false);
        boolean flag = ((TypeSettingMapper)this.baseMapper).updateYzTendersStatus(entity.getTenderNo(), 1);
        if (!flag) {
            throw new BusinessException("\u66f4\u6539\u4e91\u7b51\u7f51\u62db\u6807\u72b6\u6001\u5931\u8d25\uff01");
        }
        List<SettingSupplierInfoEntity> settingSupplierInfoEntities = entity.getSettingSupplierInfoEntities();
        for (SettingSupplierInfoEntity s : settingSupplierInfoEntities) {
            List productInfoList = BeanMapper.mapList(((TypeSettingMapper)this.baseMapper).getYzProductByTenderNo(s.getTendersNo(), s.getSupplierName(), entity.getProductType()), SettingProductInfoEntity.class);
            ArrayList<SettingProductInfoEntity> saveRedirects = new ArrayList<SettingProductInfoEntity>();
            if (CollectionUtils.isNotEmpty((Collection)productInfoList)) {
                for (SettingProductInfoEntity re : productInfoList) {
                    re.setSupplierId(s.getId());
                    re.setId(null);
                    re.setCreateTime(null);
                    saveRedirects.add(re);
                }
            }
            this.settingProductInfoService.saveBatch(saveRedirects);
        }
        TypeSettingVO vo = (TypeSettingVO)((Object)BeanMapper.map((Object)((Object)entity), TypeSettingVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public TypeSettingVO queryDetail(Long id) {
        TypeSettingEntity entity = (TypeSettingEntity)((Object)this.selectById(id));
        List<SettingSupplierInfoEntity> infoEntities = entity.getSettingSupplierInfoEntities();
        TypeSettingVO vo = (TypeSettingVO)((Object)BeanMapper.map((Object)((Object)entity), TypeSettingVO.class));
        if (infoEntities != null && infoEntities.size() > 0) {
            List settingSupplierInfoVOS = BeanMapper.mapList(infoEntities, SettingSupplierInfoVO.class);
            QueryParam queryParam = null;
            for (SettingSupplierInfoVO infovo : settingSupplierInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)infovo.getId()));
                List redirectEntities = this.settingProductInfoService.queryList(queryParam, false);
                infovo.setSettingProductInfoEntities(BeanMapper.mapList((Iterable)redirectEntities, SettingProductInfoVO.class));
                infovo.setNoticeProductEntities(BeanMapper.mapList((Iterable)redirectEntities, SettingProductInfoVO.class));
            }
            vo.setSettingSupplierInfoEntities(settingSupplierInfoVOS);
            vo.setNoticeSupplierEntities(settingSupplierInfoVOS);
        }
        return vo;
    }

    @Override
    public boolean updateSettingStatus(String settingId, int isUsed) {
        return ((TypeSettingMapper)this.baseMapper).updateSettingStatus(settingId, isUsed);
    }

    @Override
    public boolean deleteSetting(List<TypeSettingVO> vos) {
        boolean flag = true;
        ArrayList<Long> removeIds = new ArrayList<Long>();
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEntity::getId, ids);
        List settingEntities = this.list((Wrapper)queryWrapper);
        for (TypeSettingEntity s : settingEntities) {
            if (s.getIsUsed() != 0) continue;
            flag = ((TypeSettingMapper)this.baseMapper).updateYzTendersStatus(s.getTenderNo(), 0);
            if (!flag) {
                throw new BusinessException("\u5220\u9664\u8bbe\u7f6e\uff0c\u66f4\u6539\u4e91\u7b51\u7f51\u7269\u8d44\u62db\u6807\u72b6\u6001\u5931\u8d25\uff01");
            }
            removeIds.add(s.getId());
        }
        if (CollectionUtils.isNotEmpty(removeIds)) {
            super.removeByIds(removeIds, true);
        }
        return flag;
    }

    @Override
    public List<SettingSupplierInfoVO> getYzSupplier(String tenderNo) {
        return ((TypeSettingMapper)this.baseMapper).getYzSupplier(tenderNo);
    }

    @Override
    public List<YzwTenderVO> getYzTenderRef(Page<YzwTenderVO> page, QueryWrapper wrapper, Long tenantid) {
        List<YzwTenderVO> list = ((TypeSettingMapper)this.baseMapper).getYzTenderRef(page, wrapper, tenantid);
        return list;
    }
}

