package com.ejianc.business.ecxj.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 比选报价供应商实体（类似转扣）
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_compare_supplier")
public class CompareSupplierEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="compare_id")
    private Long compareId; // 比选报价主表主键ID
    @TableField(value="tender_supplier_id")
    private Long tenderSupplierId; // 比选报价物资子表主键ID
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="supplier_credit_code")
    private String supplierCreditCode; // 供应商纳税人编号

    @TableField(value="supplier_contract_person")
    private String supplierContractPerson; // 中标供应商联系人
    @TableField(value="supplier_contract_phone")
    private String supplierContractPhone; // 中标供应商联系方式

    @TableField(value="sum_mny")
    private BigDecimal sumMny; // 物资累计金额

    @TableField(value="push_status")
    private Integer pushStatus; // 报价状态，0-未推送，1-已推送， 2-已放弃

    @TableField(exist = false)
    @SubEntity(serviceName = "compareProductService",pidName = "supplierId")
    private List<CompareProductEntity> compareProductEntities = new ArrayList<>(); // 比价物资中的供应商清单实体（子表）
    @TableField(exist = false)
    @SubEntity(serviceName = "fileService",pidName = "supplierId")
    private List<FileEntity> fileList = new ArrayList<>(); // 比价物资中的供应商清单实体（子表）


    public Long getCompareId() {
        return compareId;
    }

    public void setCompareId(Long compareId) {
        this.compareId = compareId;
    }
    public Long getTenderSupplierId() {
        return tenderSupplierId;
    }

    public void setTenderSupplierId(Long tenderSupplierId) {
        this.tenderSupplierId = tenderSupplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }
    public String getSupplierContractPerson() {
        return supplierContractPerson;
    }

    public void setSupplierContractPerson(String supplierContractPerson) {
        this.supplierContractPerson = supplierContractPerson;
    }
    public String getSupplierContractPhone() {
        return supplierContractPhone;
    }

    public void setSupplierContractPhone(String supplierContractPhone) {
        this.supplierContractPhone = supplierContractPhone;
    }
    public BigDecimal getSumMny() {
        return sumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        this.sumMny = sumMny;
    }
    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }
    public List<CompareProductEntity> getCompareProductEntities() {
        return compareProductEntities;
    }

    public void setCompareProductEntities(List<CompareProductEntity> compareProductEntities) {
        this.compareProductEntities = compareProductEntities;
    }
    public List<FileEntity> getFileList() {
        return fileList;
    }

    public void setFileList(List<FileEntity> fileList) {
        this.fileList = fileList;
    }
}
