package com.ejianc.business.ecxj.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 询价通知供应商实体（类似转扣）
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_notice_supplier")
public class NoticeSupplierEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="notice_id")
    private Long noticeId; // 询价单主表主键ID
    @TableField(value="setting_supplier_id")
    private Long settingSupplierId; // 类型设置中供应商的Id
    @TableField(value="tender_supplier_id")
    private Long tenderSupplierId; // 云筑供应商Id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="supplier_credit_code")
    private String supplierCreditCode; // 供应商纳税人编号

    @TableField(value="supplier_contract_person")
    private String supplierContractPerson; // 中标供应商联系人
    @TableField(value="supplier_contract_phone")
    private String supplierContractPhone; // 中标供应商联系方式
    @TableField(value="push_status")
    private Integer pushStatus; // 推送状态，0-未推送，1-已推送

    @TableField(exist = false)
    @SubEntity(serviceName = "noticeProductService",pidName = "supplierId")
    private List<NoticeProductEntity> noticeProductEntities = new ArrayList<>(); // 物资中的商品清单实体（孙表）


    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    public Long getSettingSupplierId() {
        return settingSupplierId;
    }

    public void setSettingSupplierId(Long settingSupplierId) {
        this.settingSupplierId = settingSupplierId;
    }

    public Long getTenderSupplierId() {
        return tenderSupplierId;
    }

    public void setTenderSupplierId(Long tenderSupplierId) {
        this.tenderSupplierId = tenderSupplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }
    public String getSupplierContractPerson() {
        return supplierContractPerson;
    }

    public void setSupplierContractPerson(String supplierContractPerson) {
        this.supplierContractPerson = supplierContractPerson;
    }
    public String getSupplierContractPhone() {
        return supplierContractPhone;
    }

    public void setSupplierContractPhone(String supplierContractPhone) {
        this.supplierContractPhone = supplierContractPhone;
    }
    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }
    public List<NoticeProductEntity> getNoticeProductEntities() {
        return noticeProductEntities;
    }

    public void setNoticeProductEntities(List<NoticeProductEntity> noticeProductEntities) {
        this.noticeProductEntities = noticeProductEntities;
    }
}
