package com.ejianc.business.ecxj.controller;

import com.ejianc.business.ecxj.service.IAnalysisService;
import com.ejianc.business.ecxj.vo.AnalysisProductVO;
import com.ejianc.business.ecxj.vo.AnalysisSupplierVO;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 二次询价-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("analysis")
@Api(value = "二次询价分析", tags = {"二次询价分析"})
public class AnalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IAnalysisService service;

    /**
     * 表头数据
     * @return
     */
    @RequestMapping(value = "/getNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AnalysisVO> getNum() {
        AnalysisVO analysisVO = service.getNum();
        return  CommonResponse.success("查询成功！",analysisVO);
    }

    /**
     * 处置金额期间对比分析
     * @return
     */
    @RequestMapping(value = "/getPeriodMoney", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodMoney() {
        List<AnalysisVO> list = service.getPeriodMoney();
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 处置中标次数期间对比分析
     * @return
     */
    @RequestMapping(value = "/getPeriodCs", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodCs() {
        List<AnalysisVO> list = service.getPeriodCs();
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 获取使用情况接口
     * @return
     */
    @RequestMapping(value = "/queryDetailsList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> queryDetailsList() {
        List<AnalysisVO> list = service.queryDetailsList();
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 获取使用情况接口
     * @return
     */
    @RequestMapping(value = "/queryProductList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisProductVO>> queryProductList() {
        List<AnalysisProductVO> list = service.queryProductList();
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 获取使用情况接口
     * @return
     */
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisSupplierVO>> querySupplierList() {
        List<AnalysisSupplierVO> list = service.querySupplierList();
        return  CommonResponse.success("查询成功！",list);
    }

}
