package com.ejianc.business.ecxj.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.vo.YzwTenderVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.ecxj.bean.TypeSettingEntity;
import com.ejianc.business.ecxj.service.ITypeSettingService;
import com.ejianc.business.ecxj.vo.TypeSettingVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 集采类型设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("typeSetting")
public class TypeSettingController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITypeSettingService service;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TypeSettingVO> saveOrUpdate(@RequestBody TypeSettingVO saveOrUpdateVO) {
        /**
         *  保存时，判断供应商账号，是否在供方门户中有账户
         */
//        List<SettingSupplierInfoVO> supplierList = service.getYzSupplier(saveOrUpdateVO.getTenderNo());
//        for (SettingSupplierInfoVO supplierInfoVO : supplierList) {
//            (supplierInfoVO.getSupplierCreditCode());
//        }
        LambdaQueryWrapper<TypeSettingEntity> lambda1 = Wrappers.<TypeSettingEntity>lambdaQuery();
        lambda1.eq(TypeSettingEntity::getMaterialTypeId, saveOrUpdateVO.getMaterialTypeId())
               .eq(TypeSettingEntity::getTenderLevel, saveOrUpdateVO.getTenderLevel())
               .eq(TypeSettingEntity::getTenderNo, saveOrUpdateVO.getTenderNo())
               .eq(TypeSettingEntity::getTenderName, saveOrUpdateVO.getTenderName())
               .eq(TypeSettingEntity::getQuoteType, saveOrUpdateVO.getQuoteType());
        List<TypeSettingEntity> typeSettingEntities = service.list(lambda1);
        if ( CollectionUtils.isNotEmpty(typeSettingEntities) ) {
            throw new BusinessException("重复设置！类型设置中已包含该类型设置！");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        saveOrUpdateVO.setOrgId(orgId);
        saveOrUpdateVO.setIsUsed(0);
        saveOrUpdateVO.setSettingStatus(0);
        CommonResponse<TypeSettingVO> settingVOCommonResponse = service.saveOrUpdate(saveOrUpdateVO);
        TypeSettingVO data = settingVOCommonResponse.getData();
        return CommonResponse.success("保存或修改单据成功！", data);
    }

    /**
     * @Description saveOrUpdate
     */
    @RequestMapping(value = "/MaterialBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeSettingVO>> MaterialBatch(@RequestBody List<TypeSettingVO> saveorUpdateBatchVO) {

        Long orgId = InvocationInfoProxy.getOrgId();
        LambdaQueryWrapper<TypeSettingEntity> queryWrapperDetailOld = Wrappers.<TypeSettingEntity>lambdaQuery();
        queryWrapperDetailOld.eq(TypeSettingEntity::getOrgId, orgId);
        List<TypeSettingEntity> TypeSettingEntityListOld = service.list(queryWrapperDetailOld);
        List<TypeSettingVO> removeList =  new ArrayList<>();
        if (ListUtil.isNotEmpty(TypeSettingEntityListOld)) {

            // 过滤重复的物料，如果新引入与已引入物料，删除新引入的重复物料，保留已引入的物料及设置
            for (TypeSettingVO TypeSettingVO : saveorUpdateBatchVO){
                for (TypeSettingEntity TypeSettingEntity : TypeSettingEntityListOld){
                    if (TypeSettingVO.getId().equals(TypeSettingEntity.getId())){
                        removeList.add(TypeSettingVO);
                    }
                }
            }

        }
        if (ListUtil.isNotEmpty(removeList)){
            saveorUpdateBatchVO.removeAll(removeList);
        }

        for (TypeSettingVO TypeSettingVO : saveorUpdateBatchVO){
            TypeSettingVO.setOrgId(orgId);
        }
//        return CommonResponse.success("保存或修改单据成功！",saveorUpdateBatchVO);     // 若批量引入，则将去重后数据返回
        List<TypeSettingEntity> listEntity = BeanMapper.mapList(saveorUpdateBatchVO, TypeSettingEntity.class);
        service.saveOrUpdateBatch(listEntity);
        List<TypeSettingVO> vo = BeanMapper.mapList(listEntity, TypeSettingVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TypeSettingVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description updateSettingStatus 封存设置，改变状态
     * @param vos
     */
    @RequestMapping(value = "/updateSettingStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeSettingVO>> updateSettingStatus(@RequestBody List<TypeSettingVO> vos) {
        /**
         *  判断是否已被引用
         */
        //修改计划状态
        List<TypeSettingVO> updateList = new ArrayList<>();
        List<TypeSettingVO> throwList = new ArrayList<>();
        vos.forEach(t -> {
//            if (t.getIsUsed() == 1 || t.getSettingStatus() == 1) {
            if (t.getSettingStatus() == 1) {
                throwList.add(t);
            } else {
                t.setSettingStatus(1);
                updateList.add(t);
            }
        });
        List<TypeSettingEntity> listEntity = new ArrayList<>();
        if (updateList != null && updateList.size() > 0) {
            listEntity = BeanMapper.mapList(updateList, TypeSettingEntity.class);
            boolean flag = service.updateBatchById(listEntity);
            if (!flag){
                throw new BusinessException("封存类型设置失败！");
            }
        } else {
            throw new BusinessException( "所选材料类型设置已封存或已被引用，无法再封存！" );
        }
        List<TypeSettingVO> vos1 = BeanMapper.mapList(listEntity, TypeSettingVO.class);
        return CommonResponse.success("封存类型设置成功！",vos1);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TypeSettingVO> vos) {
        service.deleteSetting(vos);
//        service.removeByIds(vos.stream().map(TypeSettingVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeSettingVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("tenderNo");
        fuzzyFields.add("tenderName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if(null!=orgId&&orgId>0){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }else{
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }

        IPage<TypeSettingEntity> page = service.queryPage(param,false);
        IPage<TypeSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TypeSettingVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TypeSettingEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TypeSetting-export.xlsx", beans, response);
    }


    /**
     * 云筑网招标信息参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/yzTenderRef")
    @ResponseBody
    public CommonResponse<JSONObject> yzTenderRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                     @RequestParam(defaultValue = "10") Integer pageSize,
                                                     @RequestParam(value = "condition", required = false) String condition,
                                                     @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("tendersNo");
        fuzzyFields.add("tendersName");
        fuzzyFields.add("orgName");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
//        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));

        Page<YzwTenderVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<YzwTenderVO> list = service.getYzTenderRef(page,wrapper,InvocationInfoProxy.getTenantid());
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * 集采类型设置参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/typeSettingRef")
    @ResponseBody
    public CommonResponse<IPage<TypeSettingVO>> typeSettingRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                     @RequestParam(defaultValue = "10") Integer pageSize,
                                                     @RequestParam(value = "condition", required = false) String condition,
                                                     @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("tenderNo");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("settingStatus", new Parameter(QueryParam.EQ, 0));
//        queryParam.getParams().put("isUsed", new Parameter(QueryParam.EQ, 0));

        IPage<TypeSettingEntity> page = service.queryPage(queryParam, false);
        IPage<TypeSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TypeSettingVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }
}
