package com.ejianc.business.ecxj.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.vo.SettingProductInfoVO;
import com.ejianc.business.ecxj.vo.SettingSupplierInfoVO;
import com.ejianc.business.ecxj.vo.YzwTenderVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.ecxj.bean.TypeSettingEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 集采类型设置
 * 
 * @author generator
 * 
 */
@Mapper
public interface TypeSettingMapper extends BaseCrudMapper<TypeSettingEntity> {

    @Select("select * from tenders_supplier_info where tender_no=#{tenderNo}")
    List<SettingSupplierInfoVO> getYzSupplier(@Param("tenderNo") String tenderNo);

    List<YzwTenderVO> getYzTenderRef(Page<YzwTenderVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param("tenantId") Long tenantId);

    @Select("select id tenderSupplierId, tenders_no, supplier_name, supplier_credit_code, " +
            "supplier_contract_person, supplier_contract_phone " +
            "from tenders_supplier_info where tenders_no=#{tenderNo} and supplier_type=#{productType}")
    List<SettingSupplierInfoVO> getYzSupplierByTenderNo(@Param("tenderNo") String tenderNo, @Param("productType") String productType);

    @Select("select *, id tenderProductId from tenders_product_info where tenders_no=#{tendersNo} " +
            "and supplier_name=#{supplierName} and product_type=#{productType}")
    List<SettingProductInfoVO> getYzProductByTenderNo(@Param("tendersNo") String tendersNo,
                                                      @Param("supplierName") String supplierName,
                                                      @Param("productType") String productType);

    @Update("update ejc_ecxj_type_setting set is_used=#{isUsed} where id =#{settingId}")
    boolean updateSettingStatus(@Param("settingId") String settingId, @Param("isUsed") int isUsed);

    @Update("update tenders_info set is_used=#{isUsed} where tenders_no =#{tendersNo}")
    boolean updateYzTendersStatus(@Param("tendersNo") String tendersNo, @Param("isUsed") int isUsed);
}
