package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierTenderEntity;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import com.ejianc.business.ecxj.mapper.AnalysisMapper;
import com.ejianc.business.ecxj.service.IAnalysisService;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.ICompareSupplierTenderService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.vo.AnalysisProductVO;
import com.ejianc.business.ecxj.vo.AnalysisSupplierVO;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.business.ecxj.vo.CompareSupplierTenderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 文件关联实体
 * 
 * @author generator
 * 
 */
@Service("analysisService")
public class AnalysisServiceImpl extends BaseServiceImpl<AnalysisMapper, CompareEntity> implements IAnalysisService {

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierTenderService compareSupplierTenderService;

    @Override
    public AnalysisVO getNum() {

        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        AnalysisVO analysisVO = new AnalysisVO();

        LambdaQueryWrapper<NoticeEntity> lambda1 = Wrappers.<NoticeEntity>lambdaQuery();
        LambdaQueryWrapper<CompareEntity> lambda2 = Wrappers.<CompareEntity>lambdaQuery();
        lambda1.in(NoticeEntity::getOrgId, commonOrgIds);
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List<NoticeEntity> noticeEntities = noticeService.list(lambda1);
        List<CompareEntity> compareEntities = compareService.list(lambda2);

        // 上线项目数、比选次数
        BigDecimal projectNum = BigDecimal.ZERO;
        BigDecimal compareNum = BigDecimal.ZERO;
        List<Long> compareIds = null;
        if (CollectionUtils.isNotEmpty(compareEntities)){
            List<Long> projectIds = noticeEntities.stream().map(NoticeEntity::getProjectId).distinct().collect(Collectors.toList());
            compareIds = compareEntities.stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
            long count = projectIds.stream().count();
            projectNum = BigDecimal.valueOf(count);
            compareNum = BigDecimal.valueOf( compareEntities.size() );
        }
        analysisVO.setProjectNum(projectNum);
        analysisVO.setCompareNum(compareNum);

        // 累计中标次数
        BigDecimal tenderNum = BigDecimal.ZERO;
        BigDecimal moneyNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(compareIds)) {
            LambdaQueryWrapper<CompareSupplierTenderEntity> lambdaTender = Wrappers.<CompareSupplierTenderEntity>lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List<CompareSupplierTenderEntity> cstList = compareSupplierTenderService.list(lambdaTender);
            if (CollectionUtils.isNotEmpty(cstList)){
                moneyNum = cstList.stream().map(CompareSupplierTenderEntity::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                tenderNum = BigDecimal.valueOf( cstList.size() );
            }
        }
        analysisVO.setTenderNum(tenderNum);
        analysisVO.setMoneyNum(moneyNum);
        return analysisVO;
    }

    @Override
    public List<AnalysisVO> getPeriodMoney() {
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        //获取时间区间
        List<AnalysisVO> analysisList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

        //比选中标金额
        LambdaQueryWrapper<CompareEntity> lambda2 = Wrappers.<CompareEntity>lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List<CompareEntity> compareEntities = compareService.list(lambda2);

        List<Long> compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<String, List<CompareSupplierTenderVO>> periodMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(compareEntities)){
            compareIds = compareEntities.stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper<CompareSupplierTenderEntity> lambdaTender = Wrappers.<CompareSupplierTenderEntity>lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List<CompareSupplierTenderEntity> cstList = compareSupplierTenderService.list(lambdaTender);
            if (CollectionUtils.isNotEmpty(cstList)) {
                List<CompareSupplierTenderVO> cstVOList = BeanMapper.mapList(cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }

        for (int i = 6; i > 0; i--){
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setPeriod(period);
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            if (periodMap.containsKey(period)){
                List<CompareSupplierTenderVO> supplierTenderVOList = periodMap.get(period);
                moneyTaxNum = supplierTenderVOList.stream().map(CompareSupplierTenderVO::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                BigDecimal bigDecimal = moneyTaxNum.divide(new BigDecimal(10000), 8, BigDecimal.ROUND_HALF_UP);
                analysisVO.setMoneyNum(moneyTaxNum);
            };
            analysisList.add(analysisVO);
            calendar.add(Calendar.MONTH, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> getPeriodCs() {
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        //获取时间区间
        List<AnalysisVO> analysisList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

        //比选中标次数
        LambdaQueryWrapper<CompareEntity> lambda2 = Wrappers.<CompareEntity>lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List<CompareEntity> compareEntities = compareService.list(lambda2);

        List<Long> compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<String, List<CompareSupplierTenderVO>> periodMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(compareEntities)){
            compareIds = compareEntities.stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper<CompareSupplierTenderEntity> lambdaTender = Wrappers.<CompareSupplierTenderEntity>lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List<CompareSupplierTenderEntity> cstList = compareSupplierTenderService.list(lambdaTender);
            if (CollectionUtils.isNotEmpty(cstList)) {
                List<CompareSupplierTenderVO> cstVOList = BeanMapper.mapList(cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }

        for (int i = 6; i> 0;i--){
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            analysisVO.setPeriod(period);
            if (periodMap.containsKey(period)){
                List<CompareSupplierTenderVO> csTenderVOList = periodMap.get(period);
                analysisVO.setFrequency(csTenderVOList.size());
            };
            analysisList.add(analysisVO);
            calendar.add(Calendar.MONTH, -1);
        }

        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> queryDetailsList() {
        QueryParam param = new QueryParam();
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Page<AnalysisVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AnalysisVO> list = baseMapper.queryDetailsList(page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisProductVO> queryProductList() {
        QueryParam param = new QueryParam();
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Page<AnalysisVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AnalysisProductVO> list = baseMapper.queryProductList(page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisSupplierVO> querySupplierList() {
        QueryParam param = new QueryParam();
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Page<AnalysisVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AnalysisSupplierVO> list = baseMapper.querySupplierList(page, wrapper);
        return list;
    }
}
