package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.util.C;
import com.ejianc.business.ecxj.vo.CompareSupplierTenderVO;
import com.ejianc.business.ecxj.vo.CompareVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.Wrappers.update;

@Service("compare") 
public class CompareBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ICompareService compareService;

	@Value("${common.env.base-host}")
	private String baseHost;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		// 1、撤回后，单据自动变为自由态，填报单状态为未中标状态
		LambdaUpdateWrapper<CompareEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(CompareEntity::getId, billId);
		updateWrapper.set(CompareEntity::getCompareStatus, 0);
		update(updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------------------------终审审核完回调！---------------------------");
		logger.info("---------------------------baseHost！---------------------------"+baseHost+"---------------------------------");
		CompareVO vo = compareService.queryDetail(billId);
		String corpName = vo.getCropName();
		String projectName = vo.getProjectName();
		String materialTypeName = vo.getMaterialTypeName();
		List<CompareSupplierTenderVO> compareSupplierTenderVOS = vo.getCompareSupplierTenderEntities();
		for (CompareSupplierTenderVO c : compareSupplierTenderVOS) {
			String linkman = c.getSupplierContractPerson();
			String phone = c.getSupplierContractPhone();
			String bizid = AliyunSMSUtil.sendSMSLogin1(C.ECXUN_TENDER, phone, linkman, projectName, materialTypeName, corpName);  // 供应商、联系人、联系电话、云筑中标编号
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 1、弃审后，单据自动变为自由态，填报单状态为未中标状态
		LambdaUpdateWrapper<CompareEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(CompareEntity::getId, billId);
		updateWrapper.set(CompareEntity::getCompareStatus, 0);
		update(updateWrapper);
		return CommonResponse.success();
	}

}
