/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.service.IAnalysisService;
import com.ejianc.business.ecxj.vo.AnalysisProductVO;
import com.ejianc.business.ecxj.vo.AnalysisSupplierVO;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"analysis"})
@Api(value="\u4e8c\u6b21\u8be2\u4ef7\u5206\u6790", tags={"\u4e8c\u6b21\u8be2\u4ef7\u5206\u6790"})
public class AnalysisController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAnalysisService service;

    @RequestMapping(value={"/getNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AnalysisVO> getNum() {
        AnalysisVO analysisVO = this.service.getNum();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)analysisVO);
    }

    @RequestMapping(value={"/getPeriodMoney"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodMoney() {
        List<AnalysisVO> list = this.service.getPeriodMoney();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/getPeriodCs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodCs() {
        List<AnalysisVO> list = this.service.getPeriodCs();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryDetailsList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> queryDetailsList() {
        List<AnalysisVO> list = this.service.queryDetailsList();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryProductPriceList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProductPriceList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("productName");
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AnalysisProductVO> list = this.service.queryProductPriceList((Page<AnalysisProductVO>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryProductRateList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProductRateList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("productName");
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AnalysisProductVO> list = this.service.queryProductRateList((Page<AnalysisProductVO>)page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/querySupplierList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AnalysisSupplierVO>> querySupplierList(String productName) {
        List<AnalysisSupplierVO> list = this.service.querySupplierList(productName);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }
}

