package com.ejianc.business.ecxj.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 比选报价物资明细实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_compare_product")
public class CompareProductEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="supplier_id")
    private Long supplierId; // 比选报价供应商子表主键ID
    @TableField(value="tender_product_id")
    private Long tenderProductId; // 云筑物资Id
    @TableField(value="product_name")
    private String productName; // 商品名称
    @TableField(value="product_spec")
    private String productSpec; // 规格型号
    @TableField(value="product_unit")
    private String productUnit; // 计量单位
    @TableField(value="tender_num")
    private BigDecimal tenderNum; // 招标数量

    @TableField(value="product_price")
    private BigDecimal productPrice; // 云筑网，单价/下浮率
    @TableField(value="product_rate")
    private String productRate; // 税率，云筑网
    @TableField(value="product_lower_rate")
    private BigDecimal productLowerRate; // 集采下浮率，云筑网
    @TableField(value="fill_price")
    private BigDecimal fillPrice; // 税前单价/下浮率（填报）
    @TableField(value="push_mny")
    private BigDecimal pushMny; // 报价金额
    @TableField(value="memo")
    private String memo; // 报价依据


    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Long getTenderProductId() {
        return tenderProductId;
    }

    public void setTenderProductId(Long tenderProductId) {
        this.tenderProductId = tenderProductId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getProductSpec() {
        return productSpec;
    }

    public void setProductSpec(String productSpec) {
        this.productSpec = productSpec;
    }
    public String getProductUnit() {
        return productUnit;
    }

    public void setProductUnit(String productUnit) {
        this.productUnit = productUnit;
    }
    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }
    public BigDecimal getProductPrice() {
        return productPrice;
    }

    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }
    public String getProductRate() {
        return productRate;
    }

    public void setProductRate(String productRate) {
        this.productRate = productRate;
    }

    public BigDecimal getProductLowerRate() {
        return productLowerRate;
    }

    public void setProductLowerRate(BigDecimal productLowerRate) {
        this.productLowerRate = productLowerRate;
    }

    public BigDecimal getFillPrice() {
        return fillPrice;
    }

    public void setFillPrice(BigDecimal fillPrice) {
        this.fillPrice = fillPrice;
    }
    public BigDecimal getPushMny() {
        return pushMny;
    }

    public void setPushMny(BigDecimal pushMny) {
        this.pushMny = pushMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
