package com.ejianc.business.ecxj.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 云筑网物资实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ecxj_type_setting_product")
public class SettingProductInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="supplier_id")
    private Long supplierId; // 设置Id
    @TableField(value="tender_product_id")
    private Long tenderProductId; // 云筑物资Id，用于改变云筑网中的状态
    @TableField(value="tenders_no")
    private String tendersNo; // 招标编号
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="product_name")
    private String productName; // 供应商纳税人编号
    @TableField(value="product_spec")
    private String productSpec; // 中标供应商联系人
    @TableField(value="product_unit")
    private String productUnit; // 中标供应商联系方式
    @TableField(value="product_price")
    private BigDecimal productPrice; // 中标供应商联系方式
    @TableField(value="product_rate")
    private String productRate; // 中标供应商联系方式
    @TableField(value="product_lower_rate")
    private BigDecimal productLowerRate; // 中标供应商联系方式
    @TableField(value="create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime; // 创建时间

    @TableField(value="memo")
    private String memo; // 报价依据

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getTenderProductId() {
        return tenderProductId;
    }

    public void setTenderProductId(Long tenderProductId) {
        this.tenderProductId = tenderProductId;
    }

    public String getTendersNo() {
        return tendersNo;
    }

    public void setTendersNo(String tendersNo) {
        this.tendersNo = tendersNo;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductSpec() {
        return productSpec;
    }

    public void setProductSpec(String productSpec) {
        this.productSpec = productSpec;
    }

    public String getProductUnit() {
        return productUnit;
    }

    public void setProductUnit(String productUnit) {
        this.productUnit = productUnit;
    }

    public BigDecimal getProductPrice() {
        return productPrice;
    }

    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    public String getProductRate() {
        return productRate;
    }

    public void setProductRate(String productRate) {
        this.productRate = productRate;
    }

    public BigDecimal getProductLowerRate() {
        return productLowerRate;
    }

    public void setProductLowerRate(BigDecimal productLowerRate) {
        this.productLowerRate = productLowerRate;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
