package com.ejianc.business.ecxj.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.service.IAnalysisService;
import com.ejianc.business.ecxj.vo.AnalysisProductVO;
import com.ejianc.business.ecxj.vo.AnalysisSupplierVO;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 二次询价-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("analysis")
@Api(value = "二次询价分析", tags = {"二次询价分析"})
public class AnalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAnalysisService service;

    /**
     * 表头数据
     * @return
     */
    @RequestMapping(value = "/getNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AnalysisVO> getNum() {
        AnalysisVO analysisVO = service.getNum();
        return  CommonResponse.success("查询成功！",analysisVO);
    }

    /**
     * 处置金额期间对比分析
     * @return
     */
    @RequestMapping(value = "/getPeriodMoney", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodMoney() {
        List<AnalysisVO> list = service.getPeriodMoney();
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 处置中标次数期间对比分析
     * @return
     */
    @RequestMapping(value = "/getPeriodCs", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> getPeriodCs() {
        List<AnalysisVO> list = service.getPeriodCs();
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 获取使用情况接口
     * @return
     */
    @RequestMapping(value = "/queryDetailsList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisVO>> queryDetailsList() {
        List<AnalysisVO> list = service.queryDetailsList();
        return  CommonResponse.success("查询成功！",list);
    }

    /**
     * 获取使用情况接口
     * @return
     */
    @RequestMapping(value = "/queryProductPriceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryProductPriceList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("productName");
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Page<AnalysisProductVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AnalysisProductVO> list = service.queryProductPriceList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * 获取使用情况接口
     * @return
     */
    @RequestMapping(value = "/queryProductRateList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryProductRateList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("productName");
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Page<AnalysisProductVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AnalysisProductVO> list = service.queryProductRateList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return  CommonResponse.success("查询成功！",res);
    }

    /**
     * 获取使用情况接口
     * @return
     */
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AnalysisSupplierVO>> querySupplierList(String productName) {
        List<AnalysisSupplierVO> list = service.querySupplierList(productName);
        return  CommonResponse.success("查询成功！",list);
    }

}
