package com.ejianc.business.ecxj.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.vo.AnalysisProductVO;
import com.ejianc.business.ecxj.vo.AnalysisSupplierVO;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 二次询价分析
 * 
 * @author generator
 * 
 */
@Mapper
public interface AnalysisMapper extends BaseCrudMapper<CompareEntity> {

    List<AnalysisVO> queryDetailsList(Page<AnalysisVO> page, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<AnalysisProductVO> queryProductPriceList(Page<AnalysisProductVO> page, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<AnalysisProductVO> queryProductRateList(Page<AnalysisProductVO> page, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<AnalysisSupplierVO> querySupplierList(@Param("productName") String productName, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

}
