package com.ejianc.business.ecxj.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.*;
import com.ejianc.business.ecxj.mapper.AnalysisMapper;
import com.ejianc.business.ecxj.service.*;
import com.ejianc.business.ecxj.vo.AnalysisProductVO;
import com.ejianc.business.ecxj.vo.AnalysisSupplierVO;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.business.ecxj.vo.CompareSupplierTenderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 文件关联实体
 * 
 * @author generator
 * 
 */
@Service("analysisService")
public class AnalysisServiceImpl extends BaseServiceImpl<AnalysisMapper, CompareEntity> implements IAnalysisService {

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierService compareSupplierService;
    @Autowired
    private ICompareProductService compareProductService;
    @Autowired
    private ICompareSupplierTenderService compareSupplierTenderService;

    @Override
    public AnalysisVO getNum() {

        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        AnalysisVO analysisVO = new AnalysisVO();

        LambdaQueryWrapper<NoticeEntity> lambda1 = Wrappers.<NoticeEntity>lambdaQuery();
        LambdaQueryWrapper<CompareEntity> lambda2 = Wrappers.<CompareEntity>lambdaQuery();
        lambda1.in(NoticeEntity::getOrgId, commonOrgIds);
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List<NoticeEntity> noticeEntities = noticeService.list(lambda1);
        List<CompareEntity> compareEntities = compareService.list(lambda2);

        // 上线项目数、比选次数
        BigDecimal projectNum = BigDecimal.ZERO;
        BigDecimal compareNum = BigDecimal.ZERO;
        List<Long> compareIds = null;
        if (CollectionUtils.isNotEmpty(compareEntities)){
            //projectNum是从ejc_ecxj_notice表中获取的，DISTINCT project_id去重并且dr=0
            List<Long> projectIds = noticeEntities.stream().map(NoticeEntity::getProjectId).distinct().collect(Collectors.toList());
            //compareNum是从ejc_ecxj_compare表中获取的，dr=0，这个数目前来看，之前的计算逻辑就是计算所有的比价单的数量
            compareIds = compareEntities.stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
            long count = projectIds.stream().count();
            projectNum = BigDecimal.valueOf(count);
            compareNum = BigDecimal.valueOf( compareEntities.size() );
        }
        analysisVO.setProjectNum(projectNum);
        analysisVO.setCompareNum(compareNum);

        // 累计中标次数,累计中标金额
        BigDecimal tenderNum = BigDecimal.ZERO;
        BigDecimal moneyNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(compareIds)) {
            LambdaQueryWrapper<CompareSupplierTenderEntity> lambdaTender = Wrappers.<CompareSupplierTenderEntity>lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List<CompareSupplierTenderEntity> cstList = compareSupplierTenderService.list(lambdaTender);
            //是从ejc_ecxj_compare_supplier_tender中查询到cstList的数量
            if (CollectionUtils.isNotEmpty(cstList)){
                // 原方法：有问题，当累加时遇见了值为null的情况，程序报错
                // moneyNum = cstList.stream().map(CompareSupplierTenderEntity::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                // 方法一：使用filter过滤掉值为null的情况，然后再累加
                // moneyNum = cstList.stream().filter( (element -> null != element.getTenderMny())).map(CompareSupplierTenderEntity::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                // 方法二：对cstList使用for循环过滤掉值为null的情况，然后再累加
                for (CompareSupplierTenderEntity compareSupplierTenderEntity : cstList) {
                    if (null != compareSupplierTenderEntity.getTenderMny()){
                        moneyNum = moneyNum.add(compareSupplierTenderEntity.getTenderMny());
                    }
                }
                //tenderNum是直接按cstList的size来计算的
                tenderNum = BigDecimal.valueOf( cstList.size() );
            }
        }
        analysisVO.setTenderNum(tenderNum);
        analysisVO.setMoneyNum(moneyNum);
        return analysisVO;
    }

    @Override
    public List<AnalysisVO> getPeriodMoney() {
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        //获取时间区间
        List<AnalysisVO> analysisList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

        //比选中标金额
        LambdaQueryWrapper<CompareEntity> lambda2 = Wrappers.<CompareEntity>lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List<CompareEntity> compareEntities = compareService.list(lambda2);

        List<Long> compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<String, List<CompareSupplierTenderVO>> periodMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(compareEntities)){
            compareIds = compareEntities.stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper<CompareSupplierTenderEntity> lambdaTender = Wrappers.<CompareSupplierTenderEntity>lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List<CompareSupplierTenderEntity> cstList = compareSupplierTenderService.list(lambdaTender);
            if (CollectionUtils.isNotEmpty(cstList)) {
                List<CompareSupplierTenderVO> cstVOList = BeanMapper.mapList(cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }

        for (int i = 6; i > 0; i--){
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setPeriod(period);
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            if (periodMap.containsKey(period)){
                List<CompareSupplierTenderVO> supplierTenderVOList = periodMap.get(period);
                moneyTaxNum = supplierTenderVOList.stream().map(CompareSupplierTenderVO::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                BigDecimal bigDecimal = moneyTaxNum.divide(new BigDecimal(10000), 8, BigDecimal.ROUND_HALF_UP);
                analysisVO.setMoneyNum(moneyTaxNum);
            };
            analysisList.add(analysisVO);
            calendar.add(Calendar.MONTH, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> getPeriodCs() {
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        //获取时间区间
        List<AnalysisVO> analysisList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

        //比选中标次数
        LambdaQueryWrapper<CompareEntity> lambda2 = Wrappers.<CompareEntity>lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List<CompareEntity> compareEntities = compareService.list(lambda2);

        List<Long> compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<String, List<CompareSupplierTenderVO>> periodMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(compareEntities)){
            compareIds = compareEntities.stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper<CompareSupplierTenderEntity> lambdaTender = Wrappers.<CompareSupplierTenderEntity>lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List<CompareSupplierTenderEntity> cstList = compareSupplierTenderService.list(lambdaTender);
            if (CollectionUtils.isNotEmpty(cstList)) {
                List<CompareSupplierTenderVO> cstVOList = BeanMapper.mapList(cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }

        for (int i = 6; i> 0;i--){
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            analysisVO.setPeriod(period);
            if (periodMap.containsKey(period)){
                List<CompareSupplierTenderVO> csTenderVOList = periodMap.get(period);
                analysisVO.setFrequency(csTenderVOList.size());
            };
            analysisList.add(analysisVO);
            calendar.add(Calendar.MONTH, -1);
        }

        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> queryDetailsList() {
        QueryParam param = new QueryParam();
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Page<AnalysisVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AnalysisVO> list = baseMapper.queryDetailsList(page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisProductVO> queryProductPriceList(Page<AnalysisProductVO> page, QueryWrapper wrapper) {
        List<AnalysisProductVO> list = baseMapper.queryProductPriceList(page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisProductVO> queryProductRateList(Page<AnalysisProductVO> page, QueryWrapper wrapper) {
        List<AnalysisProductVO> list = baseMapper.queryProductRateList(page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisSupplierVO> querySupplierList(String productName) {
        QueryParam param = new QueryParam();
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Page<AnalysisVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AnalysisSupplierVO> list = baseMapper.querySupplierList(productName, wrapper);
        for (AnalysisSupplierVO as : list) {
            // 材料总比选次数
            LambdaQueryWrapper<CompareProductEntity> lambda = Wrappers.<CompareProductEntity>lambdaQuery();
            lambda.like(CompareProductEntity::getProductName, productName);
            List<CompareProductEntity> compareProductEntities1 = compareProductService.list(lambda);
            as.setProductCompareNum(BigDecimal.valueOf(compareProductEntities1.size()));
            // 指定供应商下的某种材料参与比选次数
//            List<Long> attendSupplierIds = compareProductEntities1.stream().map(CompareProductEntity::getSupplierId).distinct().collect(Collectors.toList());
//            LambdaQueryWrapper<CompareSupplierEntity> lambda11 = Wrappers.<CompareSupplierEntity>lambdaQuery();
//            lambda11.in(CompareSupplierEntity::getId, attendSupplierIds).eq(CompareSupplierEntity::getSupplierName, as.getSupplierName());
//            as.setAttendCompareNum( BigDecimal.valueOf(compareSupplierService.list(lambda11).size()) );
            // 供应商中标次数
            LambdaQueryWrapper<CompareSupplierTenderEntity> lambda2 = Wrappers.<CompareSupplierTenderEntity>lambdaQuery();
            lambda2.eq(CompareSupplierTenderEntity::getTenderSupplierName, as.getSupplierName());
            List<Long> supplierCompareIdList = compareSupplierTenderService.list(lambda2).stream().map(CompareSupplierTenderEntity::getCompareId).distinct().collect(Collectors.toList());
            if ( supplierCompareIdList != null && supplierCompareIdList.size() > 0) {
                LambdaQueryWrapper<CompareSupplierEntity> lambda3 = Wrappers.<CompareSupplierEntity>lambdaQuery();
                lambda3.in(CompareSupplierEntity::getCompareId, supplierCompareIdList).eq(CompareSupplierEntity::getSupplierName, as.getSupplierName());
                List<Long> supplierIds = compareSupplierService.list(lambda3).stream().map(CompareSupplierEntity::getId).distinct().collect(Collectors.toList());
                if (productName.equals("")) {
                    as.setTenderNum(BigDecimal.valueOf(supplierIds.size()));
                } else {
                    LambdaQueryWrapper<CompareProductEntity> lambda4 = Wrappers.<CompareProductEntity>lambdaQuery();
                    lambda4.in(CompareProductEntity::getSupplierId, supplierIds).like(CompareProductEntity::getProductName, productName);
                    as.setTenderNum(BigDecimal.valueOf(compareProductService.list(lambda4).size()));
                }
            }
            // 算术平均固定价
            List<Long> compareIdList = compareSupplierTenderService.list(lambda2).stream().map(CompareSupplierTenderEntity::getCompareId).distinct().collect(Collectors.toList());
            if (compareIdList != null && compareIdList.size() > 0) {
                LambdaQueryWrapper<CompareEntity> lambda5 = Wrappers.<CompareEntity>lambdaQuery();
                lambda5.in(CompareEntity::getId, compareIdList).eq(CompareEntity::getQuoteType, 0);    // 固定单价
                List<Long> compareQuoteTypeIds = compareService.list(lambda5).stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
                if (compareQuoteTypeIds != null && compareQuoteTypeIds.size() > 0 ) {
                    LambdaQueryWrapper<CompareSupplierEntity> lambda6 = Wrappers.<CompareSupplierEntity>lambdaQuery();
                    lambda6.in(CompareSupplierEntity::getCompareId, compareQuoteTypeIds).eq(CompareSupplierEntity::getSupplierName, as.getSupplierName());
                    List<Long> supplierQuoteTypeIds = compareSupplierService.list(lambda6).stream().map(CompareSupplierEntity::getId).distinct().collect(Collectors.toList());
                    if (supplierQuoteTypeIds != null && supplierQuoteTypeIds.size() > 0) {
                        LambdaQueryWrapper<CompareProductEntity> lambda7 = Wrappers.<CompareProductEntity>lambdaQuery();
                        lambda7.in(CompareProductEntity::getSupplierId, supplierQuoteTypeIds).like(CompareProductEntity::getProductName, productName);
                        List<CompareProductEntity> compareProductEntities = compareProductService.list(lambda7);
                        BigDecimal productPriceSum = compareProductEntities.stream().map(CompareProductEntity::getProductPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal productFillSum = compareProductEntities.stream().filter(s -> s.getFillPrice()!=null).map(CompareProductEntity::getFillPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal tenderNumSum = compareProductEntities.stream().map(CompareProductEntity::getTenderNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        as.setMeticMeanValue(tenderNumSum.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : productPriceSum.subtract(productFillSum).divide(tenderNumSum, 2, BigDecimal.ROUND_HALF_UP));
                        BigDecimal weighPrice = BigDecimal.ZERO;
                        for (CompareProductEntity cp : compareProductEntities) {
                            if (cp.getFillPrice() != null) {
                                weighPrice = cp.getProductPrice().subtract(cp.getFillPrice()).multiply(cp.getTenderNum());
                            }
                        }
                        as.setWeighMeanValue(tenderNumSum.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : weighPrice.divide(tenderNumSum, 2, BigDecimal.ROUND_HALF_UP));
                    }
                }
                // 下浮率
                LambdaQueryWrapper<CompareEntity> lambda8 = Wrappers.<CompareEntity>lambdaQuery();
                lambda8.in(CompareEntity::getId, compareIdList).eq(CompareEntity::getQuoteType, 1);    // 固定单价
                List<Long> compareQuoteTypeIds2 = compareService.list(lambda8).stream().map(CompareEntity::getId).distinct().collect(Collectors.toList());
                if ( compareQuoteTypeIds2 != null && compareQuoteTypeIds2.size() > 0 ) {
                    LambdaQueryWrapper<CompareSupplierEntity> lambda9 = Wrappers.<CompareSupplierEntity>lambdaQuery();
                    lambda9.in(CompareSupplierEntity::getCompareId, compareQuoteTypeIds2).eq(CompareSupplierEntity::getSupplierName, as.getSupplierName());
                    List<Long> supplierQuoteTypeIds2 = compareSupplierService.list(lambda9).stream().map(CompareSupplierEntity::getId).distinct().collect(Collectors.toList());
                    LambdaQueryWrapper<CompareProductEntity> lambda10 = Wrappers.<CompareProductEntity>lambdaQuery();
                    lambda10.in(CompareProductEntity::getSupplierId, supplierQuoteTypeIds2).like(CompareProductEntity::getProductName, productName);
                    List<CompareProductEntity> compareProductEntities2 = compareProductService.list(lambda10);
                    BigDecimal productPriceSum2 = compareProductEntities2.stream().filter(s -> s.getProductLowerRate()!=null).map(CompareProductEntity::getProductLowerRate).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal productFillSum2 = compareProductEntities2.stream().filter(s -> s.getFillPrice()!=null).map(CompareProductEntity::getFillPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal tenderNumSum2 = compareProductEntities2.stream().map(CompareProductEntity::getTenderNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    as.setMeticMeanRate(tenderNumSum2.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : productFillSum2.subtract(productPriceSum2).divide(tenderNumSum2, 2, BigDecimal.ROUND_HALF_UP));
                    BigDecimal weighRate = BigDecimal.ZERO;
                    for (CompareProductEntity cp : compareProductEntities2) {
                        if (cp.getFillPrice() != null && cp.getProductLowerRate() != null) {
                            weighRate = cp.getFillPrice().subtract(cp.getProductLowerRate()).multiply(cp.getTenderNum());
                        }
                    }
                    as.setWeighMeanRate(tenderNumSum2.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : weighRate.divide(tenderNumSum2, 2, BigDecimal.ROUND_HALF_UP));
                }
            }
        }
        return list;
    }
}
