package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierTenderEntity;
import com.ejianc.business.ecxj.mapper.CompareMapper;
import com.ejianc.business.ecxj.mapper.CompareSupplierTenderMapper;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.ICompareSupplierService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.util.C;
import com.ejianc.business.ecxj.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.baomidou.mybatisplus.core.toolkit.Wrappers.update;

@Service("compare")
@Slf4j
public class CompareBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ISupplierApi supplierApi;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private INoticeService noticeService;
	@Autowired
	private ICompareService compareService;
	@Autowired
	private ICompareSupplierService compareSupplierService;
	@Autowired
	private IAttachmentApi attachmentApi;

	@Value("${common.env.base-host}")
	private String baseHost;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	@Autowired
	CompareMapper compareMapper;

	@Autowired
	CompareSupplierTenderMapper compareSupplierTenderMapper;
	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		// 1、撤回后，单据自动变为自由态，填报单状态为未中标状态
//		LambdaUpdateWrapper<CompareEntity> updateWrapper = new LambdaUpdateWrapper<>();
//		updateWrapper.eq(CompareEntity::getId, billId);
//		updateWrapper.set(CompareEntity::getCompareStatus, 0);

		try {
			QueryWrapper<CompareEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("id", billId);
			List<CompareEntity> compareEntities = compareMapper.selectList(queryWrapper);
			log.error("二次询价驳回Id====》"+ billId);
			logger.info("logger.info二次询价驳回Id====》"+ billId);
			if(CollectionUtils.isNotEmpty(compareEntities)){
				CompareEntity compareEntity = compareEntities.get(0);
				compareEntity.setCompareStatus(0);

				log.error("找到二次询价驳回的实体====》"+ billId);
				logger.info("logger.info找到二次询价驳回的实体====》"+ billId);
				compareMapper.updateById(compareEntity);
				log.error("找到二次询价驳回的实体并设置其compareStatus为0====》"+ compareEntity.getCompareStatus());
				logger.info("logger.info找到二次询价驳回的实体并设置其compareStatus为0====》"+ compareEntity.getCompareStatus());
				logger.error("二次询价驳回后CompareStatus的值====》"+ compareEntity.getCompareStatus());
				logger.error("logger.二次询价驳回后CompareStatus的值====》"+ compareEntity.getCompareStatus());
				logger.error("二次询价驳回后billStatus的值====》"+ compareEntity.getBillState());
				logger.error("logger.二次询价驳回后billStatus的值====》"+ compareEntity.getBillState());

				// 删除对应的供应商中标信息列表
				QueryWrapper<CompareSupplierTenderEntity> compareSupplierTenderEntityQueryWrapper = new QueryWrapper<>();
				compareSupplierTenderEntityQueryWrapper.eq("compare_id", billId);
				List<CompareSupplierTenderEntity> compareSupplierTenderEntities = compareSupplierTenderMapper.selectList(compareSupplierTenderEntityQueryWrapper);
				int result = 0;
				logger.info("logger.info找到中标实体的id值====》"+ compareSupplierTenderEntities.get(0).getId());
				logger.info("logger.info找到中标实体的compare_id值====》"+ compareSupplierTenderEntities.get(0).getCompareId());
				result = compareSupplierTenderMapper.deleteCompareSupplierTenderByCompareId(compareSupplierTenderEntities.get(0).getCompareId());
				logger.error("delete return count = " + result);
				if(result > 0){
					logger.error("logger.二次询价驳回后将compareSupplierTenderEntityQueryWrapper的中标值删除====》");
				}else{
					logger.error("logger.驳回后compareSupplierTenderEntityQueryWrapper中标值删除失败====》");
				}

			}else{
				log.error("没有找到二次询价驳回的实体===>"+ billId);
				logger.info("logger.info没有找到二次询价驳回的实体===>"+ billId);
			}
		} catch (Exception e) {
			e.printStackTrace();
			log.error(e.getLocalizedMessage());
		}

		// update(updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		QueryWrapper<CompareEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id", billId);
		List<CompareEntity> compareEntities = compareMapper.selectList(queryWrapper);
		log.error("二次询价审批前回调Id====》"+ billId);
		if(CollectionUtils.isNotEmpty(compareEntities)) {
			CompareEntity compareEntity = compareEntities.get(0);
			log.error("找到二次询价审批前回调的实体====》" + billId);
			log.error("找到二次询价审批前回调的实体其compareStatus的值====》" + compareEntity.getCompareStatus());
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
			QueryWrapper<CompareEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("id", billId);
			List<CompareEntity> compareEntities = compareMapper.selectList(queryWrapper);
			log.error("二次询价终审审核前回调Id====》"+ billId);
			if(CollectionUtils.isNotEmpty(compareEntities)) {
				CompareEntity compareEntity = compareEntities.get(0);
				log.error("找到二次询价终审审核前回调的实体====》" + billId);
				log.error("找到二次询价终审审核前回调的实体其compareStatus的值====》" + compareEntity.getCompareStatus());
			}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------------------------终审审核完回调！---------------------------");
		logger.info("---------------------------baseHost！---------------------------"+baseHost+"---------------------------------");
		CompareVO vo = compareService.queryDetail(billId);
		String corpName = vo.getCropName();
		String projectName = vo.getProjectName();
		String materialTypeName = vo.getMaterialTypeName();
		List<CompareSupplierTenderVO> compareSupplierTenderVOS = vo.getCompareSupplierTenderEntities();
		for (CompareSupplierTenderVO c : compareSupplierTenderVOS) {
			String linkman = c.getSupplierContractPerson();
			String phone = c.getSupplierContractPhone();
			String bizid = AliyunSMSUtil.sendSMSLogin1(C.ECXUN_TENDER, phone, linkman, projectName, materialTypeName, null, null, corpName);  // 供应商、联系人、联系电话、云筑中标编号
		}

		//推送供方
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = noticeService.getAccessToken(headers);
		NoticeSuplVO noticeSuplVO = BeanMapper.map(vo, NoticeSuplVO.class);
		List<CompareSupplierVO> compareSupplierVOS = vo.getCompareSupplierEntities(); // 1、供应商列表，遍历每个供应商
		List<CompareSupplierTenderVO> tenderSupplierVOList = vo.getCompareSupplierTenderEntities();
		logger.info("获取供方token  tokenres.isSuccess() --"+tokenres.isSuccess());
		// 比价单，compareVO
		if(tokenres.isSuccess()){
			// 获取供应商信息，将供应商赋值给物资明细中的Supplier字段
			for (CompareSupplierVO compareSupplierVO : compareSupplierVOS) {
				for (CompareSupplierTenderVO tenderSupplierVO : tenderSupplierVOList) {
					// 中标通知单：主表
					noticeSuplVO.setTenderSupplier(tenderSupplierVO.getTenderSupplierName());
					CommonResponse<List<SupplierVO>> supplier = supplierApi.queryByCreditCode(compareSupplierVO.getSupplierCreditCode());
					if (supplier.isSuccess() && CollectionUtils.isNotEmpty(supplier.getData())) {
						SupplierVO supplierVO = supplier.getData().get(0);
						noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
						noticeSuplVO.setSupplierName(tenderSupplierVO.getTenderSupplierName());
						noticeSuplVO.setSupplierCreditCode(supplierVO.getSocialCreditCode());
					}

					// 中标通知单物资信息：子表
					LambdaQueryWrapper<CompareSupplierEntity> queryWrapper = Wrappers.<CompareSupplierEntity>lambdaQuery();
					queryWrapper.eq(CompareSupplierEntity::getCompareId, tenderSupplierVO.getCompareId())
							.eq(CompareSupplierEntity::getSupplierCreditCode, tenderSupplierVO.getSupplierCreditCode());
					CompareSupplierEntity compareSupplierEntity = compareSupplierService.getOne(queryWrapper);
					CompareSupplierEntity compareSupplierEntity1 =  compareSupplierService.selectById(compareSupplierEntity.getId());
					noticeSuplVO.setNoticeSuplProductEntities(BeanMapper.mapList(compareSupplierEntity1.getCompareProductEntities(), NoticeSuplProductVO.class));

					//获取附件  传送供方
					List<FileVO> orderfileList = new ArrayList<>();
					CommonResponse<List<AttachmentVO>> fileResponse = attachmentApi.queryListBySourceId(vo.getId(), "BT230327000000001", "quoteFile", null);
					if (fileResponse.isSuccess() && fileResponse.getData() != null && fileResponse.getData().size() > 0) {
						List<AttachmentVO> fileList = fileResponse.getData();
						for (AttachmentVO fileVo : fileList) {
							FileVO file = new FileVO();
							file.setFileName(fileVo.getFileName());
							file.setFilePath(fileVo.getFilePath());
							file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
							file.setFileBizPk(vo.getId().toString());
							file.setDr(0);
							file.setFileBiz("ecxj");// 订单业务标识
							file.setBizType("0");// 附件业务标识：0-轻量化传递，1-供方上传
							orderfileList.add(file);
						}
					}
					noticeSuplVO.setFileList(orderfileList);

//					logger.info("获取供方token--" + headers);
//					CommonResponse<String> pushres = compareService.pushTender(headers, noticeSuplVO);
//					logger.info("获取推送供方结果--" + pushres);
//					if (pushres.isSuccess()) {
//						//推送成功后处理逻辑
////						noticeSupplierVO.setPushStatus(1);  // 已推送
////					noticeService.saveOrUpdate(noticeEntity,false);
//					} else {
//						return pushres;
//					}
				}
			}
//			CompareEntity entity = BeanMapper.map(noticeEntity, CompareEntity.class);
		}else{
			return tokenres;
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 1、弃审后，单据自动变为自由态，填报单状态为未中标状态
		LambdaUpdateWrapper<CompareEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(CompareEntity::getId, billId);
		updateWrapper.set(CompareEntity::getCompareStatus, 0);
		update(updateWrapper);
		try {
			QueryWrapper<CompareEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("id", billId);
			List<CompareEntity> compareEntities = compareMapper.selectList(queryWrapper);
			log.error("二次询价驳回Id====》"+ billId);
			if(CollectionUtils.isNotEmpty(compareEntities)){
				CompareEntity compareEntity = compareEntities.get(0);
				compareEntity.setCompareStatus(0);
				log.error("找到二次询价驳回的实体====》"+ billId);

				compareMapper.updateById(compareEntity);
				log.error("找到二次询价驳回的实体并设置其compareStatus为0====》"+ billId);
				logger.error("二次询价驳回后CompareStatus的值====》"+ compareEntity.getCompareStatus());
				logger.error("二次询价驳回后billStatus的值====》"+ compareEntity.getBillState());
			}else{
				log.error("没有找到二次询价驳回的实体===>"+ billId);
			}
		} catch (Exception e) {
			e.printStackTrace();
			log.error(e.getLocalizedMessage());
		}
		return CommonResponse.success();
	}

}
