package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.vo.CompareSupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.ecxj.mapper.CompareSupplierMapper;
import com.ejianc.business.ecxj.bean.CompareSupplierEntity;
import com.ejianc.business.ecxj.service.ICompareSupplierService;

import java.util.List;

/**
 * 比选报价供应商实体（类似转扣）
 * 
 * @author generator
 * 
 */
@Service("compareSupplierService")
public class CompareSupplierServiceImpl extends BaseServiceImpl<CompareSupplierMapper, CompareSupplierEntity> implements ICompareSupplierService{

    @Autowired
    private ICompareSupplierService compareSupplierService;

    @Override
    public CompareSupplierVO queryTenderDetail(Long compareId, String supplierName) {
        LambdaQueryWrapper<CompareSupplierEntity> queryWrapper = Wrappers.<CompareSupplierEntity>lambdaQuery();
        queryWrapper.eq(CompareSupplierEntity::getCompareId, compareId).eq(CompareSupplierEntity::getSupplierName, supplierName);
        CompareSupplierEntity compareSupplierEntity = compareSupplierService.getOne(queryWrapper);
        return BeanMapper.map(compareSupplierService.selectById(compareSupplierEntity.getId()), CompareSupplierVO.class);
    }
}
