package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.*;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.util.C;
import com.ejianc.business.ecxj.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("notice") 
public class NoticeBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ISupplierApi supplierApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
	@Autowired
	private IAttachmentApi attachmentApi;

	@Value("${common.env.base-host}")
	private String baseHost;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// todo
		logger.info("---------------------------终审审核完回调！---------------------------");
		logger.info("---------------------------baseHost！---------------------------"+baseHost+"---------------------------------");
		NoticeVO noticeVO = noticeService.queryDetail(billId);
		NoticeSuplVO noticeSuplVO = BeanMapper.map(noticeVO, NoticeSuplVO.class);
		String yzTenderNo = noticeVO.getTenderNo();
		//推送供方
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = noticeService.getAccessToken(headers);
		logger.info("获取供方token  tokenres.isSuccess() --"+tokenres.isSuccess());
		// 比价单，compareVO
		if(tokenres.isSuccess()){
			// 获取供应商信息，将供应商赋值给物资明细中的Supplier字段
			List<NoticeSupplierVO> noticeSupplierVOS = noticeVO.getNoticeSupplierEntities(); // 1、供应商列表，遍历每个供应商
			for (NoticeSupplierVO noticeSupplierVO : noticeSupplierVOS) {
				CommonResponse<List<SupplierVO>> supplier = supplierApi.queryByCreditCode(noticeSupplierVO.getSupplierCreditCode());
				if(supplier.isSuccess() && CollectionUtils.isNotEmpty(supplier.getData())){
					SupplierVO  supplierVO = supplier.getData().get(0);
					noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
					noticeSuplVO.setSupplierName(supplierVO.getName());
					noticeSuplVO.setSupplierCreditCode(supplierVO.getSocialCreditCode());
				}
				noticeSuplVO.setNoticeSuplProductEntities( BeanMapper.mapList(noticeSupplierVO.getNoticeProductEntities(), NoticeSuplProductVO.class) );

				//获取附件  传送供方
				List<FileVO> orderfileList = new ArrayList<>();
				CommonResponse<List<AttachmentVO>> fileResponse = attachmentApi.queryListBySourceId(noticeVO.getId(), "BT230318000000002", "noticeFile", null);
				if (fileResponse.isSuccess() && fileResponse.getData() != null && fileResponse.getData().size() > 0) {
					List<AttachmentVO> fileList = fileResponse.getData();
					for (AttachmentVO fileVo : fileList) {
						FileVO file = new FileVO();
						file.setFileName(fileVo.getFileName());
						file.setFilePath(fileVo.getFilePath());
						file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
						file.setFileBizPk(noticeVO.getId().toString());
						file.setDr(0);
						file.setFileBiz("ecxj");// 订单业务标识
						file.setBizType("0");// 附件业务标识：0-轻量化传递，1-供方上传
						orderfileList.add(file);
					}
				}
				noticeSuplVO.setFileList(orderfileList);

				logger.info("获取供方token--"+headers);
				CommonResponse<String> pushres = noticeService.pushNotice(headers, noticeSuplVO);
				logger.info("获取推送供方结果--"+pushres);
				logger.info("发送短信开始：通知供应商二次比价start：--" + C.ECXUN_NOTICE);
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String submitDeadline = sdf.format(noticeSuplVO.getSubmitDeadline()).toString();
				String bizid = AliyunSMSUtil.sendSMSLogin1(C.ECXUN_NOTICE,
														   noticeSupplierVO.getSupplierContractPhone(),
														   noticeSupplierVO.getSupplierContractPerson(),
														   noticeSuplVO.getProjectName(),
														   noticeSuplVO.getMaterialTypeName(),
															noticeSuplVO.getWjLinkman(),
															noticeSuplVO.getWjLinkphone(),
															submitDeadline);  // 通知供应商二次询价
				logger.info("发送短信结束：通知供应商二次比价end：--" + bizid);
				if(pushres.isSuccess()){
					//推送成功后处理逻辑
					noticeSupplierVO.setPushStatus(1);  // 已推送
//					noticeService.saveOrUpdate(noticeEntity,false);
				}else{
					return pushres;
				}
			}
//			CompareEntity entity = BeanMapper.map(noticeEntity, CompareEntity.class);
		}else{
			return tokenres;
		}
		/*
		生成比价单
		 */
		CompareVO compareVO= compareService.generateCompareBill(noticeVO);
		compareService.saveOrUpdate(compareVO);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LambdaQueryWrapper<CompareEntity> queryWrapper = Wrappers.<CompareEntity>lambdaQuery();
		queryWrapper.eq(CompareEntity::getNoticeId, billId);
		CompareEntity compareEntity = compareService.getOne(queryWrapper);
		CompareEntity compareEntity1 = compareService.selectById(compareEntity.getId());
		List<CompareSupplierEntity> compareSupplierEntities = compareEntity1.getCompareSupplierEntities();
		for (CompareSupplierEntity s : compareSupplierEntities) {
			if(s.getPushStatus()!=null && s.getPushStatus() == 1) {
				return CommonResponse.error("该通知单已被供方提交报价，不允许删除！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 1、通知单弃审，删除比价单
		LambdaQueryWrapper<CompareEntity> queryWrapper = Wrappers.<CompareEntity>lambdaQuery();
		queryWrapper.eq(CompareEntity::getNoticeId, billId);
		CompareEntity compareEntity = compareService.getOne(queryWrapper);
		List<CompareVO> compareList =  new ArrayList<CompareVO>();
		compareList.add(BeanMapper.map(compareEntity, CompareVO.class));
		boolean flag = compareService.deleteCompare(compareList);

		// 2、调用供方接口，删除供方二次询价单
		//推送供方
		Map<String, String> headers = new HashMap<>();
		NoticeEntity noticeEntity = noticeService.selectById(billId);
		CommonResponse<String> tokenres = noticeService.getAccessToken(headers);
		if(tokenres.isSuccess()) {
			logger.info("获取供方token--" + headers);
			CommonResponse<String> pushres = noticeService.pushDelNotice(headers, noticeEntity);
			logger.info("获取推送供方结果--" + pushres);
		}else{
			return CommonResponse.error("调用供方失败,请联系管理员");
		}


		return CommonResponse.success();
	}

}
