package com.ejianc.business.ecxj.util;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

@Slf4j
public class AliyunSMSUtil {

    /**
     * 发送登录短信验证码
     *
     * @param phone
     * @param code
     * @return
     */
    public static String sendSMSLogin(String phone, String code) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", code);
        return sendSMS(phone, C.ALIYUN_SMS_TEMPLATE_CODE, jsonObject.toString());
    }

    private static String sendSMS(String phone, String templateId, String params) {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        final String product = "Dysmsapi";
        final String domain = "dysmsapi.aliyuncs.com";
        final String accessKeyId = C.ALIYUN_SMS_ACCESS_KEY_ID;
        final String accessKeySecret = C.ALIYUN_SMS_ACCESS_KEY_SECRET;
        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId,
                accessKeySecret);
        try {
            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
            IAcsClient acsClient = new DefaultAcsClient(profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setMethod(MethodType.POST);
            request.setPhoneNumbers(phone);
            request.setSignName(C.ALIYUN_SMS_SIGN_NAME);
            request.setTemplateCode(templateId);
            request.setTemplateParam(params);
            SendSmsResponse sendSmsResponse = acsClient.getAcsResponse(request);
            if (sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
                log.error("sendSMS phone: " + phone + " bizid:" + sendSmsResponse.getBizId());
                return sendSmsResponse.getBizId();
            }
        } catch (ClientException e) {
            log.error("phone:" + phone + " error code:" + e.getErrCode() + " msg:" + e.getErrMsg());
        }
        return "";
    }


    /**
     * 发送短信验证码
     * @param materialTypeName 材料类型
     * @param linkman 联系人
     * @param phone 联系电话
     * @param submitDeadline 截止日期
     * @return
     */
    public static String sendSMSLogin1(String sendType, String phone, String linkman, String projectName, String materialTypeName,
                                        String wjLinkman, String wjLinkphone, String submitDeadline)  {
        String msgid = sendsms(sendType, phone, linkman, projectName, materialTypeName, wjLinkman, wjLinkphone, submitDeadline) ;
        //延迟10秒后获取状态报告
//        try {Thread.sleep(10000);} catch (Exception e) {}
//        recv(phone,code);
        return msgid;
    }

    // 短信通知：供应商中标
    public static String  sendsms(String sendType, String phone, String linkman, String projectName, String materialTypeName,
                                   String wjLinkman, String wjLinkphone, String param)  {
        // TODO Auto-generated method stub
        // message = "【中建五局】尊敬的[" + linkman + "]：["+supplierName+"]进行二次比价，云筑招标编号[" + yzTenderNo + "]";
        // message = "【中建五局】恭喜[" + linkman + "]：["+supplierName+"]成为中建五局云筑网中标商，云筑招标编号[" + yzTenderNo + "]";
        String message = null;
        if (sendType.equals("NOTICE")) {
            message = "【中建五局】尊敬的[" + linkman + "]：["+projectName+"]项目[" + materialTypeName + "](材料、设备）二次比选邀请贵司参与，请登录中建五局供方系统于["+ param +"]（时间）之前完成报价，过期不候，视同自动放弃。 " +
                    "联系人：" + wjLinkman + ", 联系电话：" + wjLinkphone;
        } else if (sendType.equals("TENDER")) {
            message = "【中建五局】恭喜[" + linkman + "]：贵司中标["+param+"] [" + projectName + "]项目[" + materialTypeName + "](材料、设备）二次比选";
        } else if (sendType.equals("COMPARE")) {
            message = "【中建五局】尊敬的[" + linkman + "]：["+projectName+"]项目[" + materialTypeName + "](材料、设备）二次比选开标时间已至，请登录中建五局轻量化二次询价系统完成报价比选。 " ;
        }
        try {
            URL url = new URL(C.YOU_SPACES_SUBMITSMIP);
            HttpURLConnection httpConn = (HttpURLConnection) url.openConnection();
            httpConn.setConnectTimeout(30000); // 设置发起连接的等待时间，30s
            httpConn.setReadTimeout(30000); // 设置数据读取超时的时间，30s
            httpConn.setUseCaches(false); // 设置不使用缓存
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");

//            httpConn.setRequestProperty("Connection", "Keep-Alive");
            httpConn.setRequestProperty("Connection","Close");
            httpConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
            httpConn.setRequestProperty("Content-Type", "application/json;charset=utf-8 Accept-Language:UTF-8");
            OutputStream os = httpConn.getOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(os);


            log.error( "时间："+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) ,
                    account=C.YOU_SPACES_ACCOUNTNAME,pwd=C.YOU_SPACES_PWD,
                    SourceAddr=C.SOURCEADDR,
                    DestAddr=phone,
                    service = C.YOU_SPACES_SERVICECODE,
                    msg = message;
            String key = StringUtil.md5("MD5:"+account+":"+pwd+":"+date) ;
            String mask = "{\"accountName\":\"$ACCOUNTNAME$\",\"Authorization\":{\"Algorithm\":\"MD5\",\"Date\":\"$DATE$\",\"HASHHEX\":\"$KEY$\"},\"DestAddr\":\"$DESTADDR$\",\"SourceAddr\":\"$SOURCEADDR$\",\"Content\":\"$MSG$\",\"ServiceCode\":\"$SERVICE$\"}" ;

            String content = "\r\n";
            content += mask.replace("$ACCOUNTNAME$", account).replace("$DATE$", date).replace("$KEY$", key).replace("$SERVICE$", service)
                    .replace("$DESTADDR$", DestAddr).replace("$SOURCEADDR$", SourceAddr).replace("$MSG$", msg)	;
            content       += "\r\n"  ;
            bos.write(content.getBytes());


            bos.flush();
            bos.close();
            os.close();

            // 读取返回数据
            StringBuffer strBuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    httpConn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line).append("\n");
            }
            String res = strBuf.toString();
            log.error("sendSMS phone: " + phone + " bizid:" + res);
            reader.close();
            httpConn.disconnect();
            JSONObject jsonObject = new JSONObject(res);
            Integer result = jsonObject.getInt("result");
            if (result != null && result == 0) {
                return jsonObject.getJSONArray("MsgIDs").getString(0);
            }
        }catch(Exception e){
            log.error("phone:" + phone +   " msg:" + e.getMessage());
        }
        return null;
    }


    public static void recv(String phone, String code)  {
        // TODO Auto-generated method stub
        try{
            URL url = new URL(C.YOU_SPACES_RCVSMSIP);
            HttpURLConnection httpConn = (HttpURLConnection) url.openConnection();
            httpConn.setConnectTimeout(3000); // 设置发起连接的等待时间，3s
            httpConn.setReadTimeout(30000); // 设置数据读取超时的时间，30s
            httpConn.setUseCaches(false); // 设置不使用缓存
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");

            httpConn.setRequestProperty("Connection", "Keep-Alive");
            httpConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
            httpConn.setRequestProperty("Content-Type", "application/json;charset=utf-8 Accept-Language:UTF-8");
            OutputStream os = httpConn.getOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(os);

            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()),account=C.YOU_SPACES_ACCOUNTNAME,pwd=C.YOU_SPACES_PWD,
                    SourceAddr=C.SOURCEADDR,DestAddr=phone,
                    service = C.YOU_SPACES_SERVICECODE,msg="【中建五局】您的验证码为："+code+",该验证码3分钟内有效，请勿泄漏于他人。";
            String key =StringUtil.md5("MD5:"+account+":"+pwd+":"+date) ;  //
            String mask = "{\"accountName\":\"$ACCOUNTNAME$\",\"Authorization\":{\"Algorithm\":\"MD5\",\"Date\":\"$DATE$\",\"HASHHEX\":\"$KEY$\"}}" ;

            String content = "\r\n";
            content += mask.replace("$ACCOUNTNAME$", account).replace("$DATE$", date).replace("$KEY$", key) 	;
            content       += "\r\n"  ;
            bos.write(content.getBytes());


            bos.flush();
            bos.close();
            os.close();

            // 读取返回数据
            StringBuffer strBuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    httpConn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line).append("\n");
            }
            String res = strBuf.toString();
            log.error("sendSMS phone: " + phone + " bizid:" + res);
            reader.close();
            httpConn.disconnect();
        }catch(Exception e){
            log.error("phone:" + phone +   " msg:" + e.getMessage());
        }

    }

}
