package com.ejianc.business.ecxj.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 比选报价
 * 
 * @author generator
 * 
 */
public class CompareVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long noticeId; // 通知单Id
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectSourceId; // 项目来源id
    private Long cropId; // 项目所属组织id
    private String cropName; // 所属公司
    private String cropSourceId; // 项目所属组织来源id
    private Long realCorpId; // NC所属组织ID
    private String realNcCorp; // NC所属组织PK
    private String realCorpName; // NC所属组织名称
    private Long orgId; // 组织
    private String orgSourceId; // 组织来源id
    private String orgName; // 组织名称
    private String wjLinkman; // 五局项目联系人
    private String wjLinkphone; // 五局项目联系电话

    private Integer isCooperation; // 是否联合比选
    private Long coopProjectId; // 联合比选项目ID
    private String coopProjectName; // 联合比选项目名称

    private Long materialTypeId; // 材料类型Id
    private String materialTypeName; // 材料类型名称

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date submitDeadline; // 填报截止日期

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date compareTime; // 比选时间
    private Long settingId; // 引用的设置类型Id
    private Long tenderId; // 云筑招标Id
    private String tenderNo; // 云筑招标编号
    private String tenderName; // 云筑招标名称

    private String productType; // 商品清单类型
    private Integer quoteType; // 报价方式
    private Integer compareStatus; // 比价状态，0-正常，1-中标，2-流标
    private String notification; // 通知内容
    private String createName; // 申请人

    private List<CompareSupplierVO> compareSupplierEntities = new ArrayList<>(); // 比价单供应商实体（子表）
    private List<CompareSupplierTenderVO> compareSupplierTenderEntities = new ArrayList<>(); // 中标供应商实体（子表）

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public Long getCropId() {
        return cropId;
    }

    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    public String getCropName() {
        return cropName;
    }

    public void setCropName(String cropName) {
        this.cropName = cropName;
    }
    public String getCropSourceId() {
        return cropSourceId;
    }

    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }
    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }
    public String getRealNcCorp() {
        return realNcCorp;
    }

    public void setRealNcCorp(String realNcCorp) {
        this.realNcCorp = realNcCorp;
    }
    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getWjLinkman() {
        return wjLinkman;
    }

    public void setWjLinkman(String wjLinkman) {
        this.wjLinkman = wjLinkman;
    }

    public String getWjLinkphone() {
        return wjLinkphone;
    }

    public void setWjLinkphone(String wjLinkphone) {
        this.wjLinkphone = wjLinkphone;
    }

    public Integer getIsCooperation() {
        return isCooperation;
    }

    public void setIsCooperation(Integer isCooperation) {
        this.isCooperation = isCooperation;
    }

    public Long getCoopProjectId() {
        return coopProjectId;
    }

    public void setCoopProjectId(Long coopProjectId) {
        this.coopProjectId = coopProjectId;
    }

    public String getCoopProjectName() {
        return coopProjectName;
    }

    public void setCoopProjectName(String coopProjectName) {
        this.coopProjectName = coopProjectName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Date getSubmitDeadline() {
        return submitDeadline;
    }

    public void setSubmitDeadline(Date submitDeadline) {
        this.submitDeadline = submitDeadline;
    }
    public Date getCompareTime() {
        return compareTime;
    }

    public void setCompareTime(Date compareTime) {
        this.compareTime = compareTime;
    }
    public Long getSettingId() {
        return settingId;
    }

    public void setSettingId(Long settingId) {
        this.settingId = settingId;
    }
    public Long getTenderId() {
        return tenderId;
    }

    public void setTenderId(Long tenderId) {
        this.tenderId = tenderId;
    }
    public String getTenderNo() {
        return tenderNo;
    }

    public void setTenderNo(String tenderNo) {
        this.tenderNo = tenderNo;
    }
    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public Integer getQuoteType() {
        return quoteType;
    }

    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }
    public Integer getCompareStatus() {
        return compareStatus;
    }

    public void setCompareStatus(Integer compareStatus) {
        this.compareStatus = compareStatus;
    }
    public String getNotification() {
        return notification;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public List<CompareSupplierVO> getCompareSupplierEntities() {
        return compareSupplierEntities;
    }

    public void setCompareSupplierEntities(List<CompareSupplierVO> compareSupplierEntities) {
        this.compareSupplierEntities = compareSupplierEntities;
    }
    public List<CompareSupplierTenderVO> getCompareSupplierTenderEntities() {
        return compareSupplierTenderEntities;
    }

    public void setCompareSupplierTenderEntities(List<CompareSupplierTenderVO> compareSupplierTenderEntities) {
        this.compareSupplierTenderEntities = compareSupplierTenderEntities;
    }
}
