/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.business.ecxj.vo.NoticeSuplVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ResponseBody
@RequestMapping(value={"compare"})
public class CompareController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICompareService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<CompareVO> saveOrUpdate(@RequestBody CompareVO saveOrUpdateVO) {
        CommonResponse<CompareVO> compareVOCommonResponse = this.service.saveOrUpdate(saveOrUpdateVO);
        CompareVO data = (CompareVO)((Object)compareVOCommonResponse.getData());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)data));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<CompareVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.service.queryDetail(id)));
    }

    @RequestMapping(value={"/updateCompare"}, method={RequestMethod.POST})
    public CommonResponse<CompareVO> updateCompare(@RequestBody NoticeSuplVO noticeSuplVO) {
        return CommonResponse.success((String)"\u4f9b\u65b9\u63d0\u4ea4\u62a5\u4ef7\u5355\u6570\u636e\u66f4\u65b0\u6210\u529f\uff01", (Object)((Object)this.service.updateCompare(noticeSuplVO)));
    }

    @RequestMapping(value={"/postDeadline"}, method={RequestMethod.POST})
    public CommonResponse<String> postDeadline(@RequestBody CompareVO vo) {
        return this.service.postDeadline(vo);
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    public CommonResponse<CompareVO> submit(@RequestBody CompareVO vo) {
        return CommonResponse.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01", (Object)((Object)this.service.submit(vo)));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<CompareVO> vos) {
        this.service.deleteCompare(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<CompareVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("tenderNo");
        fuzzyFields.add("tenderName");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompareVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Compare-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCompareData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<CompareVO>> refCompareData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompareVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/generation"}, method={RequestMethod.POST})
    public CommonResponse<String> generationSendMessage(HttpServletRequest request) {
        this.logger.info("\u8c03\u62e8\u5b9a\u65f6\u4efb\u52a1\u8fdb\u5165\u6210\u529f");
        String generateDate = request.getParameter("generateDate");
        this.logger.info("generateDate\u53c2\u6570\u4e3a\uff1a" + generateDate);
        this.service.generation(request);
        return CommonResponse.success((String)"\u8c03\u62e8\u5355\u6279\u91cf\u751f\u6210\u6210\u529f\uff01");
    }
}

