/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.CompareProductEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierTenderEntity;
import com.ejianc.business.ecxj.bean.NoticeEntity;
import com.ejianc.business.ecxj.mapper.AnalysisMapper;
import com.ejianc.business.ecxj.service.IAnalysisService;
import com.ejianc.business.ecxj.service.ICompareProductService;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.ICompareSupplierService;
import com.ejianc.business.ecxj.service.ICompareSupplierTenderService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.vo.AnalysisProductVO;
import com.ejianc.business.ecxj.vo.AnalysisSupplierVO;
import com.ejianc.business.ecxj.vo.AnalysisVO;
import com.ejianc.business.ecxj.vo.CompareSupplierTenderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="analysisService")
public class AnalysisServiceImpl
extends BaseServiceImpl<AnalysisMapper, CompareEntity>
implements IAnalysisService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierService compareSupplierService;
    @Autowired
    private ICompareProductService compareProductService;
    @Autowired
    private ICompareSupplierTenderService compareSupplierTenderService;

    @Override
    public AnalysisVO getNum() {
        ArrayList commonOrgIds = new ArrayList();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        AnalysisVO analysisVO = new AnalysisVO();
        LambdaQueryWrapper lambda1 = Wrappers.lambdaQuery();
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda1.in(NoticeEntity::getOrgId, commonOrgIds);
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List noticeEntities = this.noticeService.list((Wrapper)lambda1);
        List compareEntities = this.compareService.list((Wrapper)lambda2);
        BigDecimal projectNum = BigDecimal.ZERO;
        BigDecimal compareNum = BigDecimal.ZERO;
        List compareIds = null;
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            List projectIds = noticeEntities.stream().map(NoticeEntity::getProjectId).distinct().collect(Collectors.toList());
            compareIds = compareEntities.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            long count = projectIds.stream().count();
            projectNum = BigDecimal.valueOf(count);
            compareNum = BigDecimal.valueOf(compareEntities.size());
        }
        analysisVO.setProjectNum(projectNum);
        analysisVO.setCompareNum(compareNum);
        BigDecimal tenderNum = BigDecimal.ZERO;
        BigDecimal moneyNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(compareIds)) {
            LambdaQueryWrapper lambdaTender = Wrappers.lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List cstList = this.compareSupplierTenderService.list((Wrapper)lambdaTender);
            if (CollectionUtils.isNotEmpty((Collection)cstList)) {
                for (CompareSupplierTenderEntity compareSupplierTenderEntity : cstList) {
                    if (null == compareSupplierTenderEntity.getTenderMny()) continue;
                    moneyNum = moneyNum.add(compareSupplierTenderEntity.getTenderMny());
                }
                tenderNum = BigDecimal.valueOf(cstList.size());
            }
        }
        analysisVO.setTenderNum(tenderNum);
        analysisVO.setMoneyNum(moneyNum);
        return analysisVO;
    }

    @Override
    public List<AnalysisVO> getPeriodMoney() {
        ArrayList commonOrgIds = new ArrayList();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ArrayList<AnalysisVO> analysisList = new ArrayList<AnalysisVO>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List compareEntities = this.compareService.list((Wrapper)lambda2);
        List compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<Object, Object> periodMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            compareIds = compareEntities.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper lambdaTender = Wrappers.lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List cstList = this.compareSupplierTenderService.list((Wrapper)lambdaTender);
            if (CollectionUtils.isNotEmpty((Collection)cstList)) {
                List cstVOList = BeanMapper.mapList((Iterable)cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }
        for (int i = 6; i > 0; --i) {
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setPeriod(period);
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            if (periodMap.containsKey(period)) {
                List supplierTenderVOList = (List)periodMap.get(period);
                moneyTaxNum = supplierTenderVOList.stream().map(CompareSupplierTenderVO::getTenderMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                analysisVO.setMoneyNum(moneyTaxNum);
            }
            analysisList.add(analysisVO);
            calendar.add(2, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> getPeriodCs() {
        ArrayList commonOrgIds = new ArrayList();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ArrayList<AnalysisVO> analysisList = new ArrayList<AnalysisVO>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.in(CompareEntity::getOrgId, commonOrgIds);
        List compareEntities = this.compareService.list((Wrapper)lambda2);
        List compareIds = null;
        BigDecimal moneyTaxNum = BigDecimal.ZERO;
        Map<Object, Object> periodMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            compareIds = compareEntities.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper lambdaTender = Wrappers.lambdaQuery();
            lambdaTender.in(CompareSupplierTenderEntity::getCompareId, compareIds);
            List cstList = this.compareSupplierTenderService.list((Wrapper)lambdaTender);
            if (CollectionUtils.isNotEmpty((Collection)cstList)) {
                List cstVOList = BeanMapper.mapList((Iterable)cstList, CompareSupplierTenderVO.class);
                for (CompareSupplierTenderVO c : cstVOList) {
                    Date createTime = c.getCreateTime();
                    String period = sdf.format(createTime);
                    c.setPeriod(period);
                }
                periodMap = cstVOList.stream().collect(Collectors.groupingBy(CompareSupplierTenderVO::getPeriod));
            }
        }
        for (int i = 6; i > 0; --i) {
            Date time = calendar.getTime();
            String period = sdf.format(time);
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setMoneyNum(BigDecimal.ZERO);
            analysisVO.setPeriod(period);
            if (periodMap.containsKey(period)) {
                List csTenderVOList = (List)periodMap.get(period);
                analysisVO.setFrequency(csTenderVOList.size());
            }
            analysisList.add(analysisVO);
            calendar.add(2, -1);
        }
        Collections.reverse(analysisList);
        return analysisList;
    }

    @Override
    public List<AnalysisVO> queryDetailsList() {
        QueryParam param = new QueryParam();
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = AnalysisServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AnalysisVO> list = ((AnalysisMapper)this.baseMapper).queryDetailsList((Page<AnalysisVO>)page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisProductVO> queryProductPriceList(Page<AnalysisProductVO> page, QueryWrapper wrapper) {
        List<AnalysisProductVO> list = ((AnalysisMapper)this.baseMapper).queryProductPriceList(page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisProductVO> queryProductRateList(Page<AnalysisProductVO> page, QueryWrapper wrapper) {
        List<AnalysisProductVO> list = ((AnalysisMapper)this.baseMapper).queryProductRateList(page, wrapper);
        return list;
    }

    @Override
    public List<AnalysisSupplierVO> querySupplierList(String productName) {
        QueryParam param = new QueryParam();
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("cropId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = AnalysisServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AnalysisSupplierVO> list = ((AnalysisMapper)this.baseMapper).querySupplierList(productName, wrapper);
        for (AnalysisSupplierVO as : list) {
            List compareIdList;
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.like(CompareProductEntity::getProductName, (Object)productName);
            List compareProductEntities1 = this.compareProductService.list((Wrapper)lambda);
            as.setProductCompareNum(BigDecimal.valueOf(compareProductEntities1.size()));
            LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
            lambda2.eq(CompareSupplierTenderEntity::getTenderSupplierName, (Object)as.getSupplierName());
            List supplierCompareIdList = this.compareSupplierTenderService.list((Wrapper)lambda2).stream().map(CompareSupplierTenderEntity::getCompareId).distinct().collect(Collectors.toList());
            if (supplierCompareIdList != null && supplierCompareIdList.size() > 0) {
                LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
                ((LambdaQueryWrapper)lambda3.in(CompareSupplierEntity::getCompareId, supplierCompareIdList)).eq(CompareSupplierEntity::getSupplierName, (Object)as.getSupplierName());
                List supplierIds = this.compareSupplierService.list((Wrapper)lambda3).stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                if (productName.equals("")) {
                    as.setTenderNum(BigDecimal.valueOf(supplierIds.size()));
                } else {
                    LambdaQueryWrapper lambda4 = Wrappers.lambdaQuery();
                    ((LambdaQueryWrapper)lambda4.in(CompareProductEntity::getSupplierId, supplierIds)).like(CompareProductEntity::getProductName, (Object)productName);
                    as.setTenderNum(BigDecimal.valueOf(this.compareProductService.list((Wrapper)lambda4).size()));
                }
            }
            if ((compareIdList = this.compareSupplierTenderService.list((Wrapper)lambda2).stream().map(CompareSupplierTenderEntity::getCompareId).distinct().collect(Collectors.toList())) == null || compareIdList.size() <= 0) continue;
            LambdaQueryWrapper lambda5 = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)lambda5.in(BaseEntity::getId, compareIdList)).eq(CompareEntity::getQuoteType, (Object)0);
            List compareQuoteTypeIds = this.compareService.list((Wrapper)lambda5).stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            if (compareQuoteTypeIds != null && compareQuoteTypeIds.size() > 0) {
                LambdaQueryWrapper lambda6 = Wrappers.lambdaQuery();
                ((LambdaQueryWrapper)lambda6.in(CompareSupplierEntity::getCompareId, compareQuoteTypeIds)).eq(CompareSupplierEntity::getSupplierName, (Object)as.getSupplierName());
                List supplierQuoteTypeIds = this.compareSupplierService.list((Wrapper)lambda6).stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                if (supplierQuoteTypeIds != null && supplierQuoteTypeIds.size() > 0) {
                    LambdaQueryWrapper lambda7 = Wrappers.lambdaQuery();
                    ((LambdaQueryWrapper)lambda7.in(CompareProductEntity::getSupplierId, supplierQuoteTypeIds)).like(CompareProductEntity::getProductName, (Object)productName);
                    List compareProductEntities = this.compareProductService.list((Wrapper)lambda7);
                    BigDecimal productPriceSum = compareProductEntities.stream().map(CompareProductEntity::getProductPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal productFillSum = compareProductEntities.stream().filter(s -> s.getFillPrice() != null).map(CompareProductEntity::getFillPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal tenderNumSum = compareProductEntities.stream().map(CompareProductEntity::getTenderNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    as.setMeticMeanValue(tenderNumSum.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : productPriceSum.subtract(productFillSum).divide(tenderNumSum, 2, 4));
                    BigDecimal weighPrice = BigDecimal.ZERO;
                    for (CompareProductEntity cp : compareProductEntities) {
                        if (cp.getFillPrice() == null) continue;
                        weighPrice = cp.getProductPrice().subtract(cp.getFillPrice()).multiply(cp.getTenderNum());
                    }
                    as.setWeighMeanValue(tenderNumSum.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : weighPrice.divide(tenderNumSum, 2, 4));
                }
            }
            LambdaQueryWrapper lambda8 = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)lambda8.in(BaseEntity::getId, compareIdList)).eq(CompareEntity::getQuoteType, (Object)1);
            List compareQuoteTypeIds2 = this.compareService.list((Wrapper)lambda8).stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            if (compareQuoteTypeIds2 == null || compareQuoteTypeIds2.size() <= 0) continue;
            LambdaQueryWrapper lambda9 = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)lambda9.in(CompareSupplierEntity::getCompareId, compareQuoteTypeIds2)).eq(CompareSupplierEntity::getSupplierName, (Object)as.getSupplierName());
            List supplierQuoteTypeIds2 = this.compareSupplierService.list((Wrapper)lambda9).stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper lambda10 = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)lambda10.in(CompareProductEntity::getSupplierId, supplierQuoteTypeIds2)).like(CompareProductEntity::getProductName, (Object)productName);
            List compareProductEntities2 = this.compareProductService.list((Wrapper)lambda10);
            BigDecimal productPriceSum2 = compareProductEntities2.stream().filter(s -> s.getProductLowerRate() != null).map(CompareProductEntity::getProductLowerRate).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal productFillSum2 = compareProductEntities2.stream().filter(s -> s.getFillPrice() != null).map(CompareProductEntity::getFillPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal tenderNumSum2 = compareProductEntities2.stream().map(CompareProductEntity::getTenderNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            as.setMeticMeanRate(tenderNumSum2.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : productFillSum2.subtract(productPriceSum2).divide(tenderNumSum2, 2, 4));
            BigDecimal weighRate = BigDecimal.ZERO;
            for (CompareProductEntity cp : compareProductEntities2) {
                if (cp.getFillPrice() == null || cp.getProductLowerRate() == null) continue;
                weighRate = cp.getFillPrice().subtract(cp.getProductLowerRate()).multiply(cp.getTenderNum());
            }
            as.setWeighMeanRate(tenderNumSum2.equals(BigDecimal.ZERO) ? BigDecimal.ZERO : weighRate.divide(tenderNumSum2, 2, 4));
        }
        return list;
    }
}

