/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecxj.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.ecxj.bean.CompareEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierEntity;
import com.ejianc.business.ecxj.bean.CompareSupplierTenderEntity;
import com.ejianc.business.ecxj.mapper.CompareMapper;
import com.ejianc.business.ecxj.mapper.CompareSupplierTenderMapper;
import com.ejianc.business.ecxj.service.ICompareService;
import com.ejianc.business.ecxj.service.ICompareSupplierService;
import com.ejianc.business.ecxj.service.INoticeService;
import com.ejianc.business.ecxj.util.AliyunSMSUtil;
import com.ejianc.business.ecxj.vo.CompareSupplierTenderVO;
import com.ejianc.business.ecxj.vo.CompareSupplierVO;
import com.ejianc.business.ecxj.vo.CompareVO;
import com.ejianc.business.ecxj.vo.FileVO;
import com.ejianc.business.ecxj.vo.NoticeSuplProductVO;
import com.ejianc.business.ecxj.vo.NoticeSuplVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="compare")
public class CompareBpmServiceImpl
implements ICommonBusinessService {
    private static final Logger log = LoggerFactory.getLogger(CompareBpmServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ICompareService compareService;
    @Autowired
    private ICompareSupplierService compareSupplierService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    CompareMapper compareMapper;
    @Autowired
    CompareSupplierTenderMapper compareSupplierTenderMapper;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"id", (Object)billId);
            List compareEntities = this.compareMapper.selectList((Wrapper)queryWrapper);
            log.error("\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56deId====\u300b" + billId);
            this.logger.info("logger.info\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56deId====\u300b" + billId);
            if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
                CompareEntity compareEntity = (CompareEntity)((Object)compareEntities.get(0));
                compareEntity.setCompareStatus(0);
                log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53====\u300b" + billId);
                this.logger.info("logger.info\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53====\u300b" + billId);
                this.compareMapper.updateById((Object)compareEntity);
                log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53\u5e76\u8bbe\u7f6e\u5176compareStatus\u4e3a0====\u300b" + compareEntity.getCompareStatus());
                this.logger.info("logger.info\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53\u5e76\u8bbe\u7f6e\u5176compareStatus\u4e3a0====\u300b" + compareEntity.getCompareStatus());
                this.logger.error("\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u540eCompareStatus\u7684\u503c====\u300b" + compareEntity.getCompareStatus());
                this.logger.error("logger.\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u540eCompareStatus\u7684\u503c====\u300b" + compareEntity.getCompareStatus());
                this.logger.error("\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u540ebillStatus\u7684\u503c====\u300b" + compareEntity.getBillState());
                this.logger.error("logger.\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u540ebillStatus\u7684\u503c====\u300b" + compareEntity.getBillState());
                QueryWrapper compareSupplierTenderEntityQueryWrapper = new QueryWrapper();
                compareSupplierTenderEntityQueryWrapper.eq((Object)"compare_id", (Object)billId);
                List compareSupplierTenderEntities = this.compareSupplierTenderMapper.selectList((Wrapper)compareSupplierTenderEntityQueryWrapper);
                int result = 0;
                this.logger.info("logger.info\u627e\u5230\u4e2d\u6807\u5b9e\u4f53\u7684id\u503c====\u300b" + ((CompareSupplierTenderEntity)((Object)compareSupplierTenderEntities.get(0))).getId());
                this.logger.info("logger.info\u627e\u5230\u4e2d\u6807\u5b9e\u4f53\u7684compare_id\u503c====\u300b" + ((CompareSupplierTenderEntity)((Object)compareSupplierTenderEntities.get(0))).getCompareId());
                result = this.compareSupplierTenderMapper.deleteCompareSupplierTenderByCompareId(((CompareSupplierTenderEntity)((Object)compareSupplierTenderEntities.get(0))).getCompareId());
                this.logger.error("delete return count = " + result);
                if (result > 0) {
                    this.logger.error("logger.\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u540e\u5c06compareSupplierTenderEntityQueryWrapper\u7684\u4e2d\u6807\u503c\u5220\u9664====\u300b");
                } else {
                    this.logger.error("logger.\u9a73\u56de\u540ecompareSupplierTenderEntityQueryWrapper\u4e2d\u6807\u503c\u5220\u9664\u5931\u8d25====\u300b");
                }
            } else {
                log.error("\u6ca1\u6709\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53===>" + billId);
                this.logger.info("logger.info\u6ca1\u6709\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53===>" + billId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)billId);
        List compareEntities = this.compareMapper.selectList((Wrapper)queryWrapper);
        log.error("\u4e8c\u6b21\u8be2\u4ef7\u5ba1\u6279\u524d\u56de\u8c03Id====\u300b" + billId);
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            CompareEntity compareEntity = (CompareEntity)((Object)compareEntities.get(0));
            log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u5ba1\u6279\u524d\u56de\u8c03\u7684\u5b9e\u4f53====\u300b" + billId);
            log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u5ba1\u6279\u524d\u56de\u8c03\u7684\u5b9e\u4f53\u5176compareStatus\u7684\u503c====\u300b" + compareEntity.getCompareStatus());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)billId);
        List compareEntities = this.compareMapper.selectList((Wrapper)queryWrapper);
        log.error("\u4e8c\u6b21\u8be2\u4ef7\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03Id====\u300b" + billId);
        if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
            CompareEntity compareEntity = (CompareEntity)((Object)compareEntities.get(0));
            log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03\u7684\u5b9e\u4f53====\u300b" + billId);
            log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03\u7684\u5b9e\u4f53\u5176compareStatus\u7684\u503c====\u300b" + compareEntity.getCompareStatus());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------------------------\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff01---------------------------");
        this.logger.info("---------------------------baseHost\uff01---------------------------" + this.baseHost + "---------------------------------");
        CompareVO vo = this.compareService.queryDetail(billId);
        String corpName = vo.getCropName();
        String projectName = vo.getProjectName();
        String materialTypeName = vo.getMaterialTypeName();
        List<CompareSupplierTenderVO> compareSupplierTenderVOS = vo.getCompareSupplierTenderEntities();
        for (CompareSupplierTenderVO c : compareSupplierTenderVOS) {
            String linkman = c.getSupplierContractPerson();
            String phone = c.getSupplierContractPhone();
            String string = AliyunSMSUtil.sendSMSLogin1("TENDER", phone, linkman, projectName, materialTypeName, null, null, corpName);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.noticeService.getAccessToken(headers);
        NoticeSuplVO noticeSuplVO = (NoticeSuplVO)BeanMapper.map((Object)((Object)vo), NoticeSuplVO.class);
        List<CompareSupplierVO> compareSupplierVOS = vo.getCompareSupplierEntities();
        List<CompareSupplierTenderVO> tenderSupplierVOList = vo.getCompareSupplierTenderEntities();
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token  tokenres.isSuccess() --" + tokenres.isSuccess());
        if (tokenres.isSuccess()) {
            for (CompareSupplierVO compareSupplierVO : compareSupplierVOS) {
                for (CompareSupplierTenderVO tenderSupplierVO : tenderSupplierVOList) {
                    noticeSuplVO.setTenderSupplier(tenderSupplierVO.getTenderSupplierName());
                    CommonResponse supplier = this.supplierApi.queryByCreditCode(compareSupplierVO.getSupplierCreditCode());
                    if (supplier.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)supplier.getData()))) {
                        SupplierVO supplierVO = (SupplierVO)((List)supplier.getData()).get(0);
                        noticeSuplVO.setSupplierSourceId(supplierVO.getSourceId());
                        noticeSuplVO.setSupplierName(tenderSupplierVO.getTenderSupplierName());
                        noticeSuplVO.setSupplierCreditCode(supplierVO.getSocialCreditCode());
                    }
                    LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                    ((LambdaQueryWrapper)queryWrapper.eq(CompareSupplierEntity::getCompareId, (Object)tenderSupplierVO.getCompareId())).eq(CompareSupplierEntity::getSupplierCreditCode, (Object)tenderSupplierVO.getSupplierCreditCode());
                    CompareSupplierEntity compareSupplierEntity = (CompareSupplierEntity)((Object)this.compareSupplierService.getOne((Wrapper)queryWrapper));
                    CompareSupplierEntity compareSupplierEntity1 = (CompareSupplierEntity)((Object)this.compareSupplierService.selectById(compareSupplierEntity.getId()));
                    noticeSuplVO.setNoticeSuplProductEntities(BeanMapper.mapList(compareSupplierEntity1.getCompareProductEntities(), NoticeSuplProductVO.class));
                    ArrayList<FileVO> orderfileList = new ArrayList<FileVO>();
                    CommonResponse fileResponse = this.attachmentApi.queryListBySourceId(vo.getId(), "BT230327000000001", "quoteFile", null);
                    if (fileResponse.isSuccess() && fileResponse.getData() != null && ((List)fileResponse.getData()).size() > 0) {
                        List fileList = (List)fileResponse.getData();
                        for (AttachmentVO fileVo : fileList) {
                            FileVO file = new FileVO();
                            file.setFileName(fileVo.getFileName());
                            file.setFilePath(fileVo.getFilePath());
                            file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
                            file.setFileBizPk(vo.getId().toString());
                            file.setDr(0);
                            file.setFileBiz("ecxj");
                            file.setBizType("0");
                            orderfileList.add(file);
                        }
                    }
                    noticeSuplVO.setFileList(orderfileList);
                }
            }
        } else {
            return tokenres;
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(CompareEntity::getCompareStatus, (Object)0);
        Wrappers.update((Object)updateWrapper);
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"id", (Object)billId);
            List compareEntities = this.compareMapper.selectList((Wrapper)queryWrapper);
            log.error("\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56deId====\u300b" + billId);
            if (CollectionUtils.isNotEmpty((Collection)compareEntities)) {
                CompareEntity compareEntity = (CompareEntity)((Object)compareEntities.get(0));
                compareEntity.setCompareStatus(0);
                log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53====\u300b" + billId);
                this.compareMapper.updateById((Object)compareEntity);
                log.error("\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53\u5e76\u8bbe\u7f6e\u5176compareStatus\u4e3a0====\u300b" + billId);
                this.logger.error("\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u540eCompareStatus\u7684\u503c====\u300b" + compareEntity.getCompareStatus());
                this.logger.error("\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u540ebillStatus\u7684\u503c====\u300b" + compareEntity.getBillState());
            } else {
                log.error("\u6ca1\u6709\u627e\u5230\u4e8c\u6b21\u8be2\u4ef7\u9a73\u56de\u7684\u5b9e\u4f53===>" + billId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
        }
        return CommonResponse.success();
    }
}

