package com.ejianc.business.fjwz.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.fjwz.vo.DocumentRecordVO;
import com.ejianc.business.fjwz.vo.DocumentSellVO;
import com.ejianc.business.fjwz.vo.DocumentSupplierVO;

/**
 * 询价公告-主表
 * 
 * @author generator
 * 
 */
@ApiModel("询价公告-主表")
public class DocumentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("公告名称")
    private String documentName;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目来源ID")
    private String projectSourceId;
    @ApiModelProperty("")
    private String projectName;
    @ApiModelProperty("招标联系人")
    private Long employeeId;
    @ApiModelProperty("招标联系人名称")
    private String employeeName;
    @ApiModelProperty("招标联系人电话")
    private String employeeMobile;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("计价方式(0-固定单价,1-浮动单价,2-固定总额)")
    private Integer valueType;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("")
    private String orgName;
    @ApiModelProperty("父级组织id")
    private Long parentOrgId;
    @ApiModelProperty("父级组织name")
    private String parentOrgName;
    @ApiModelProperty("父级组织来源id")
    private Long parentOrgSourceId;
    @ApiModelProperty("询价联系人id")
    private Long doucumentLinkId;
    @ApiModelProperty("询价联系人name")
    private String doucumentLinkName;
    @ApiModelProperty("询价联系人电话")
    private String doucumentLinkMobile;
    @ApiModelProperty("询价开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date offerStartTime;
    @ApiModelProperty("询价结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date offerEndTime;
    @ApiModelProperty("文件内容")
    private String documentContent;
    @ApiModelProperty("是否开标,0-是,1-否")
    private Integer bidFlag;
    @ApiModelProperty("是否发布,0-是,1-否")
    private Integer publishFlag;
    @ApiModelProperty("是否下一步,0-是,1-否")
    private Integer nextFlag;
    @ApiModelProperty("开标时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bidTime;
    @ApiModelProperty("询价单位ID")
    private Long unitId;
    @ApiModelProperty("询价单位来源ID")
    private String unitSourceId;
    @ApiModelProperty("询价单位name")
    private String unitName;
    @ApiModelProperty("询价阶段(0-询价立项,1-询价公告,2-洽商谈判,3-询价结果,4-终止询价)")
    private Integer tenderStage;
    @ApiModelProperty("供方使用(子表明细材料分类汇总)")
    private String disposeContent;
    @ApiModelProperty("询价公告-截止时间表")
    private List<DocumentRecordVO> documentRecordList = new ArrayList<>();
    @ApiModelProperty("询价公告-报价表")
    private List<DocumentSellVO> documentSellList = new ArrayList<>();
    @ApiModelProperty("询价公告-报价供应商表")
    private List<DocumentSupplierVO> documentSupplierList = new ArrayList<>();
    @ApiModelProperty("询价公告-报价供应商表(重复显示用)")
    private List<DocumentSupplierVO> documentSupplierSellList = new ArrayList<>();
    @ApiModelProperty("询价立项-邀请供应商表")
    private List<InviteSupplierVO> inviteSupplierList = new ArrayList<>();
    @ApiModelProperty("询价立项-明细")
    private List<InviteDetailVO> inviteDetailList = new ArrayList<>();
    @ApiModelProperty("询价公告-按材料查看明细实体(二级树)")
    private List<InviteDetailVO> detailSupplierList = new ArrayList<>();

    public String getDisposeContent() {
        return disposeContent;
    }

    public void setDisposeContent(String disposeContent) {
        this.disposeContent = disposeContent;
    }

    public List<DocumentSupplierVO> getDocumentSupplierSellList() {
        return documentSupplierSellList;
    }

    public void setDocumentSupplierSellList(List<DocumentSupplierVO> documentSupplierSellList) {
        this.documentSupplierSellList = documentSupplierSellList;
    }

    public Integer getTenderStage() {
        return tenderStage;
    }

    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }

    public List<InviteDetailVO> getDetailSupplierList() {
        return detailSupplierList;
    }

    public void setDetailSupplierList(List<InviteDetailVO> detailSupplierList) {
        this.detailSupplierList = detailSupplierList;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<InviteDetailVO> getInviteDetailList() {
        return inviteDetailList;
    }

    public void setInviteDetailList(List<InviteDetailVO> inviteDetailList) {
        this.inviteDetailList = inviteDetailList;
    }

    public List<InviteSupplierVO> getInviteSupplierList() {
        return inviteSupplierList;
    }

    public void setInviteSupplierList(List<InviteSupplierVO> inviteSupplierList) {
        this.inviteSupplierList = inviteSupplierList;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 公告名称
     */
    public String getDocumentName() {
        return documentName;
    }

    /**
     * 公告名称
     */
    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目来源ID
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源ID
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织name
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织name
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织来源id
     */
    public Long getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    /**
     * 父级组织来源id
     */
    public void setParentOrgSourceId(Long parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    /**
     * 询价联系人id
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getDoucumentLinkId() {
        return doucumentLinkId;
    }

    /**
     * 询价联系人id
     */
    @ReferDeserialTransfer
    public void setDoucumentLinkId(Long doucumentLinkId) {
        this.doucumentLinkId = doucumentLinkId;
    }
    /**
     * 询价联系人name
     */
    public String getDoucumentLinkName() {
        return doucumentLinkName;
    }

    /**
     * 询价联系人name
     */
    public void setDoucumentLinkName(String doucumentLinkName) {
        this.doucumentLinkName = doucumentLinkName;
    }
    /**
     * 询价联系人电话
     */
    public String getDoucumentLinkMobile() {
        return doucumentLinkMobile;
    }

    /**
     * 询价联系人电话
     */
    public void setDoucumentLinkMobile(String doucumentLinkMobile) {
        this.doucumentLinkMobile = doucumentLinkMobile;
    }
    /**
     * 询价开始时间
     */
    public Date getOfferStartTime() {
        return offerStartTime;
    }

    /**
     * 询价开始时间
     */
    public void setOfferStartTime(Date offerStartTime) {
        this.offerStartTime = offerStartTime;
    }
    /**
     * 询价结束时间
     */
    public Date getOfferEndTime() {
        return offerEndTime;
    }

    /**
     * 询价结束时间
     */
    public void setOfferEndTime(Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }
    /**
     * 文件内容
     */
    public String getDocumentContent() {
        return documentContent;
    }

    /**
     * 文件内容
     */
    public void setDocumentContent(String documentContent) {
        this.documentContent = documentContent;
    }
    /**
     * 是否开标,0-是,1-否
     */
    public Integer getBidFlag() {
        return bidFlag;
    }

    /**
     * 是否开标,0-是,1-否
     */
    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 是否下一步,0-是,1-否
     */
    public Integer getNextFlag() {
        return nextFlag;
    }

    /**
     * 是否下一步,0-是,1-否
     */
    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }
    /**
     * 开标时间
     */
    public Date getBidTime() {
        return bidTime;
    }

    /**
     * 开标时间
     */
    public void setBidTime(Date bidTime) {
        this.bidTime = bidTime;
    }
    /**
     * 询价单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 询价单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 询价单位来源ID
     */
    public String getUnitSourceId() {
        return unitSourceId;
    }

    /**
     * 询价单位来源ID
     */
    public void setUnitSourceId(String unitSourceId) {
        this.unitSourceId = unitSourceId;
    }
    /**
     * 询价单位name
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 询价单位name
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    
     /**
      * 询价公告-截止时间表
      */
      public List<DocumentRecordVO> getDocumentRecordList() {
         return documentRecordList;
      }
     /**
      * 询价公告-截止时间表
      */
     public void setDocumentRecordList(List<DocumentRecordVO> documentRecordList) {
         this.documentRecordList = documentRecordList;
     }
     /**
      * 询价公告-报价表
      */
      public List<DocumentSellVO> getDocumentSellList() {
         return documentSellList;
      }
     /**
      * 询价公告-报价表
      */
     public void setDocumentSellList(List<DocumentSellVO> documentSellList) {
         this.documentSellList = documentSellList;
     }
     /**
      * 询价公告-报价供应商表
      */
      public List<DocumentSupplierVO> getDocumentSupplierList() {
         return documentSupplierList;
      }
     /**
      * 询价公告-报价供应商表
      */
     public void setDocumentSupplierList(List<DocumentSupplierVO> documentSupplierList) {
         this.documentSupplierList = documentSupplierList;
     }
}
