package com.ejianc.business.fjwz.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 损耗率设置
 * 
 * @author generator
 * 
 */
@ApiModel("损耗率设置")
public class LossSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long materialTypeId; // 物料分类id
    private String materialTypeName; // 物料分类名称
    private Long employeeId; // 编制人id
    private String employeeName; // 编制人名称
    private BigDecimal lossRate; // 损耗率
    private Integer status; // 状态 0-停用，1-启用
    private Long orgId; // 所属组织主键
    private String orgName; // 所属组织名称
    private String orgCode; // 所属组织编码
    private String categoryInnerCode; // 分类内码
    private String categorySourceId; // 分类来源id
    private String materialTypeCode; // 分类类型编号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date billTime;//编制时间
    private String memo;//备注

    private List<Long> ids = new ArrayList<>();

    @ReferSerialTransfer(referCode="MaterialCategory001")
    public Long getMaterialTypeId() {
        return materialTypeId;
    }
    @ReferDeserialTransfer
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getLossRate() {
        return lossRate;
    }

    public void setLossRate(BigDecimal lossRate) {
        this.lossRate = lossRate;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getCategoryInnerCode() {
        return categoryInnerCode;
    }

    public void setCategoryInnerCode(String categoryInnerCode) {
        this.categoryInnerCode = categoryInnerCode;
    }

    public String getCategorySourceId() {
        return categorySourceId;
    }

    public void setCategorySourceId(String categorySourceId) {
        this.categorySourceId = categorySourceId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}
