package com.ejianc.business.fjwz.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 询价公告-报价供应商表
 * 
 * @author generator
 * 
 */
@ApiModel("询价公告-报价供应商表")
public class DocumentSupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("")
    private Long inviteId;
    @ApiModelProperty("")
    private Long documentId;
    @ApiModelProperty("标书日期")
    private Date tenderDate;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date offerTime;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商来源id")
    private String supplierSourceId;
    @ApiModelProperty("供应商name")
    private String supplierName;
    @ApiModelProperty("供应商code")
    private String supplierCode;
    @ApiModelProperty("联系人id")
    private Long linkId;
    @ApiModelProperty("联系人name")
    private String linkName;
    @ApiModelProperty("联系电话")
    private String linkMobile;
    @ApiModelProperty("发票说明")
    private String taxMemo;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("是否中标(1:是，0：否)")
    private Integer tenderFlag;
    @ApiModelProperty("报价金额")
    private BigDecimal moneyTax;
    @ApiModelProperty("报价金额(无税)")
    private BigDecimal money;
    @ApiModelProperty("排名")
    private Integer rank;
    @ApiModelProperty("洽商轮数名称")
    private String talkNumName;
    private Integer bidFlag; // 是否开标,0-是,1-否
    @ApiModelProperty("供方报价-明细")
    private List<DocumentSellVO> documentSellList = new ArrayList<>();
    @ApiModelProperty("供方报价-轮数")
    private List<DocumentSupplierVO> documentTalkList = new ArrayList<>();

    public String getTalkNumName() {
        return talkNumName;
    }

    public void setTalkNumName(String talkNumName) {
        this.talkNumName = talkNumName;
    }

    public List<DocumentSupplierVO> getDocumentTalkList() {
        return documentTalkList;
    }

    public void setDocumentTalkList(List<DocumentSupplierVO> documentTalkList) {
        this.documentTalkList = documentTalkList;
    }

    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public List<DocumentSellVO> getDocumentSellList() {
        return documentSellList;
    }

    public void setDocumentSellList(List<DocumentSellVO> documentSellList) {
        this.documentSellList = documentSellList;
    }

    /**
     * 
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 标书日期
     */
    public Date getTenderDate() {
        return tenderDate;
    }

    /**
     * 标书日期
     */
    public void setTenderDate(Date tenderDate) {
        this.tenderDate = tenderDate;
    }
    /**
     * 报价时间
     */
    public Date getOfferTime() {
        return offerTime;
    }

    /**
     * 报价时间
     */
    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商来源id
     */
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    /**
     * 供应商来源id
     */
    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    /**
     * 供应商name
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商name
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 联系人id
     */
    public Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人id
     */
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人name
     */
    public String getLinkName() {
        return linkName;
    }

    /**
     * 联系人name
     */
    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系电话
     */
    public String getLinkMobile() {
        return linkMobile;
    }

    /**
     * 联系电话
     */
    public void setLinkMobile(String linkMobile) {
        this.linkMobile = linkMobile;
    }
    /**
     * 发票说明
     */
    public String getTaxMemo() {
        return taxMemo;
    }

    /**
     * 发票说明
     */
    public void setTaxMemo(String taxMemo) {
        this.taxMemo = taxMemo;
    }
    /**
     * 洽商轮数
     */
    public Integer getTalkNum() {
        return talkNum;
    }

    /**
     * 洽商轮数
     */
    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    /**
     * 是否中标(1:是，0：否)
     */
    public Integer getTenderFlag() {
        return tenderFlag;
    }

    /**
     * 是否中标(1:是，0：否)
     */
    public void setTenderFlag(Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }
    /**
     * 报价金额
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 报价金额
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 报价金额(无税)
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 报价金额(无税)
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    
}
