package com.ejianc.business.fjwz.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.fjwz.vo.TalkDetailVO;

/**
 * 洽商谈判-主表
 * 
 * @author generator
 * 
 */
@ApiModel("洽商谈判-主表")
public class TalkVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("询价公告主键")
    private Long documentId;
    @ApiModelProperty("来源单据主键")
    private Long billId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("洽商名称")
    private String talkName;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织id")
    private Long parentOrgId;
    @ApiModelProperty("父级组织name")
    private String parentOrgName;
    @ApiModelProperty("父级组织来源id")
    private String parentOrgSourceId;
    @ApiModelProperty("项目来源id")
    private String projectSourceId;
    @ApiModelProperty("洽商开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date talkStartTime;
    @ApiModelProperty("洽商结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date talkEndTime;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("洽商轮数名称")
    private String talkNumName;
    @ApiModelProperty("洽商参考价")
    private BigDecimal talkMoney;
    @ApiModelProperty("是否发布,0-是,1-否")
    private Integer publishFlag;
    @ApiModelProperty("是否下一步,0-是,1-否")
    private Integer nextFlag;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("询价单位ID")
    private Long unitId;
    @ApiModelProperty("询价单位来源ID")
    private String unitSourceId;
    @ApiModelProperty("询价单位name")
    private String unitName;
    @ApiModelProperty("询价阶段(0-询价立项,1-询价公告,2-洽商谈判,3-询价结果,4-终止询价)")
    private Integer tenderStage;
    
    @ApiModelProperty("洽商谈判-截止时间记录表")
    private List<TalkDetailVO> talkDetailList = new ArrayList<>();
    @ApiModelProperty("询价立项-邀请供应商表")
    private List<InviteSupplierVO> inviteSupplierList = new ArrayList<>();
    @ApiModelProperty("询价立项-明细")
    private List<InviteDetailVO> inviteDetailList = new ArrayList<>();
    @ApiModelProperty("询价公告-按材料查看明细实体(二级树)")
    private List<InviteDetailVO> detailSupplierList = new ArrayList<>();
    @ApiModelProperty("询价公告-报价供应商表")
    private List<DocumentSupplierVO> documentSupplierList = new ArrayList<>();
    @ApiModelProperty("询价公告-参与本轮报价供应商")
    private List<DocumentSupplierVO> documentSupplierNowList = new ArrayList<>();
    @ApiModelProperty("询价公告-洽商记录主表")
    private List<TalkRecordVO> talkRecordList = new ArrayList<>();

    public List<DocumentSupplierVO> getDocumentSupplierNowList() {
        return documentSupplierNowList;
    }

    public void setDocumentSupplierNowList(List<DocumentSupplierVO> documentSupplierNowList) {
        this.documentSupplierNowList = documentSupplierNowList;
    }

    public Integer getTenderStage() {
        return tenderStage;
    }

    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }

    public List<TalkRecordVO> getTalkRecordList() {
        return talkRecordList;
    }

    public void setTalkRecordList(List<TalkRecordVO> talkRecordList) {
        this.talkRecordList = talkRecordList;
    }

    public List<DocumentSupplierVO> getDocumentSupplierList() {
        return documentSupplierList;
    }

    public void setDocumentSupplierList(List<DocumentSupplierVO> documentSupplierList) {
        this.documentSupplierList = documentSupplierList;
    }

    public List<InviteSupplierVO> getInviteSupplierList() {
        return inviteSupplierList;
    }

    public void setInviteSupplierList(List<InviteSupplierVO> inviteSupplierList) {
        this.inviteSupplierList = inviteSupplierList;
    }

    public List<InviteDetailVO> getInviteDetailList() {
        return inviteDetailList;
    }

    public void setInviteDetailList(List<InviteDetailVO> inviteDetailList) {
        this.inviteDetailList = inviteDetailList;
    }

    public List<InviteDetailVO> getDetailSupplierList() {
        return detailSupplierList;
    }

    public void setDetailSupplierList(List<InviteDetailVO> detailSupplierList) {
        this.detailSupplierList = detailSupplierList;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 询价公告主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 询价公告主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 来源单据主键
     */
    public Long getBillId() {
        return billId;
    }

    /**
     * 来源单据主键
     */
    public void setBillId(Long billId) {
        this.billId = billId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 洽商名称
     */
    public String getTalkName() {
        return talkName;
    }

    /**
     * 洽商名称
     */
    public void setTalkName(String talkName) {
        this.talkName = talkName;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织name
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织name
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织来源id
     */
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    /**
     * 父级组织来源id
     */
    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    /**
     * 项目来源id
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源id
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 洽商开始时间
     */
    public Date getTalkStartTime() {
        return talkStartTime;
    }

    /**
     * 洽商开始时间
     */
    public void setTalkStartTime(Date talkStartTime) {
        this.talkStartTime = talkStartTime;
    }
    /**
     * 洽商结束时间
     */
    public Date getTalkEndTime() {
        return talkEndTime;
    }

    /**
     * 洽商结束时间
     */
    public void setTalkEndTime(Date talkEndTime) {
        this.talkEndTime = talkEndTime;
    }
    /**
     * 洽商轮数
     */
    public Integer getTalkNum() {
        return talkNum;
    }

    /**
     * 洽商轮数
     */
    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    /**
     * 洽商轮数名称
     */
    public String getTalkNumName() {
        return talkNumName;
    }

    /**
     * 洽商轮数名称
     */
    public void setTalkNumName(String talkNumName) {
        this.talkNumName = talkNumName;
    }
    /**
     * 洽商参考价
     */
    public BigDecimal getTalkMoney() {
        return talkMoney;
    }

    /**
     * 洽商参考价
     */
    public void setTalkMoney(BigDecimal talkMoney) {
        this.talkMoney = talkMoney;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 是否下一步,0-是,1-否
     */
    public Integer getNextFlag() {
        return nextFlag;
    }

    /**
     * 是否下一步,0-是,1-否
     */
    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 询价单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 询价单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 询价单位来源ID
     */
    public String getUnitSourceId() {
        return unitSourceId;
    }

    /**
     * 询价单位来源ID
     */
    public void setUnitSourceId(String unitSourceId) {
        this.unitSourceId = unitSourceId;
    }
    /**
     * 询价单位name
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 询价单位name
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    
     /**
      * 洽商谈判-截止时间记录表
      */
      public List<TalkDetailVO> getTalkDetailList() {
         return talkDetailList;
      }
     /**
      * 洽商谈判-截止时间记录表
      */
     public void setTalkDetailList(List<TalkDetailVO> talkDetailList) {
         this.talkDetailList = talkDetailList;
     }
}
