package com.ejianc.business.fjwz.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.fjwz.vo.InviteDetailVO;

/**
 * 询价立项-主表
 *
 * @author generator
 *
 */
@ApiModel("询价立项-主表")
public class InviteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目来源ID")
    private String projectSourceId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("编制人")
    private Long employeeId;
    @ApiModelProperty("编制人名称")
    private String employeeName;
    @ApiModelProperty("询价单位ID")
    private Long unitId;
    @ApiModelProperty("询价单位来源ID")
    private String unitSourceId;
    @ApiModelProperty("询价单位name")
    private String unitName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("单据状态（审批必须字段）")
    private String billStateName;
    @ApiModelProperty("询价名称")
    private String tenderName;
    @ApiModelProperty("询价阶段(0-询价立项,1-询价公告,2-洽商谈判,3-询价结果,4-终止询价)")
    private Integer tenderStage;
    private String tenderStageName;
    @ApiModelProperty("编制日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate;
    @ApiModelProperty("组织id")
    private Long orgId;
    @ApiModelProperty("组织name")
    private String orgName;
    @ApiModelProperty("上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("上级组织来源id")
    private String parentOrgSourceId;
    @ApiModelProperty("上级组织name")
    private String parentOrgName;
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    @ApiModelProperty("中标供应商")
    private String supplierName;
    @ApiModelProperty("供方sourceID")
    private String supplierSourceId;
    @ApiModelProperty("是否下一步,0-否,1-是")
    private Integer nextFlag;
    @ApiModelProperty("物资分类明细汇总")
    private String materialTypeNames;

    @ApiModelProperty("询价立项-子表")
    private List<InviteDetailVO> inviteDetailList = new ArrayList<>();

    private List<InviteSupplierVO> inviteSupplierlList = new ArrayList<>(); // 询价立项-供应商表

    public List<InviteSupplierVO> getInviteSupplierlList() {
        return inviteSupplierlList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getTenderStageName() {
        return tenderStageName;
    }

    public void setTenderStageName(String tenderStageName) {
        this.tenderStageName = tenderStageName;
    }

    public void setInviteSupplierlList(List<InviteSupplierVO> inviteSupplierlList) {
        this.inviteSupplierlList = inviteSupplierlList;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 项目来源ID
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源ID
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     *
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     *
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 询价单位ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 询价单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 询价单位来源ID
     */
    public String getUnitSourceId() {
        return unitSourceId;
    }

    /**
     * 询价单位来源ID
     */
    public void setUnitSourceId(String unitSourceId) {
        this.unitSourceId = unitSourceId;
    }
    /**
     * 询价单位name
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 询价单位name
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 询价名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 询价名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 询价阶段(0-询价立项,1-询价公告,2-洽商谈判,3-询价结果,4-终止询价)
     */
    public Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 询价阶段(0-询价立项,1-询价公告,2-洽商谈判,3-询价结果,4-终止询价)
     */
    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 编制日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 组织name
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织name
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织来源id
     */
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    /**
     * 上级组织来源id
     */
    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    /**
     * 上级组织name
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 上级组织name
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 供应商ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 中标供应商
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 中标供应商
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供方sourceID
     */
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    /**
     * 供方sourceID
     */
    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    /**
     * 是否下一步,0-否,1-是
     */
    public Integer getNextFlag() {
        return nextFlag;
    }

    /**
     * 是否下一步,0-否,1-是
     */
    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }

     /**
      * 询价立项-子表
      */
      public List<InviteDetailVO> getInviteDetailList() {
         return inviteDetailList;
      }
     /**
      * 询价立项-子表
      */
     public void setInviteDetailList(List<InviteDetailVO> inviteDetailList) {
         this.inviteDetailList = inviteDetailList;
     }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }
}
