package com.ejianc.business.fjwz.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 询价公告-主表
 * 
 * @author generator
 * 
 */
@ApiModel("询价公告-主表")
public class PushDocumentVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("公告名称")
    private String documentName;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目来源ID")
    private String sourceProjectId;
    private String projectName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("计价方式(0-固定单价,1-浮动单价,2-固定总额)")
    private Integer valueType;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("组织")
    private Long sourceOrgId;
    private String orgName;
    @ApiModelProperty("询价联系人id")
    private Long sourceEmployeeId;
    @ApiModelProperty("询价联系人name")
    private String getEmployeeName;
    @ApiModelProperty("询价联系人电话")
    private String employeeMobile;
    @ApiModelProperty("询价开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date noticeStartTime;
    @ApiModelProperty("询价结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date noticeEndTime;
    @ApiModelProperty("文件内容")
    private String documentContent;
    @ApiModelProperty("是否开标,0-是,1-否")
    private Integer bidFlag;
    @ApiModelProperty("是否发布,0-是,1-否")
    private Integer publishFlag;
    @ApiModelProperty("是否下一步,0-是,1-否")
    private Integer nextFlag;
    @ApiModelProperty("开标时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bidTime;
    @ApiModelProperty("询价单位来源ID")
    private String sourceUnitId;
    @ApiModelProperty("询价单位name")
    private String unitName;
    

}
