package com.ejianc.business.fjwz.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;

/**
 * 损耗率设置
 * 
 * @author generator
 * 
 */
@ApiModel("损耗率设置")
public class LossSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long orgId; // 所属单位主键
    private String orgName; // 所属单位名称
    private String orgCode; // 所属单位编码
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date billTime; // 编制时间
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private String projectSourceId; // 项目来源ID
    private Long parentOrgId; // 上级组织id
    private String parentOrgSourceId; // 上级组织来源id
    private String parentOrgName; // 上级组织name
    private Integer latestFlag; // 是否最新版本
    private Integer enableState; // 是否生效
    private Long lastDutyId; // 上一版本主键
    private Long changeId; // 变更单主键
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    private Integer beforeDutyVersion; // 历史版本号
    private Integer dutyVersion; // 版本
    private Long commonId; // 变更公用id
    private Date effectiveDate; // 生效时间
    private String changeReason; // 变更原因
    private String billStateName; //
    private String changeStateName; //
    
    private List<LossSetDetailVO> lossSetDetailList = new ArrayList<>(); // 损耗率设置明细
    private List<Long> ids = new ArrayList<>(); //物料分类ids

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Integer latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }
    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }
    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }
    public Long getCommonId() {
        return commonId;
    }

    public void setCommonId(Long commonId) {
        this.commonId = commonId;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public List<LossSetDetailVO> getLossSetDetailList() {
        return lossSetDetailList;
     }

     public void setLossSetDetailList(List<LossSetDetailVO> lossSetDetailList) {
        this.lossSetDetailList = lossSetDetailList;
     }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}
