package com.ejianc.business.op.api;

import com.ejianc.business.op.hystrix.ApplyHystrix;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;


/**
 *
 * @author yqls
 *
 */
@FeignClient(name= "cscec5b-op-web", url="${common.env.feign-client-url}", path="cscec5b-op-web", fallback = ApplyHystrix.class)
public interface IApplyApi {


    /**
     * 推送生成出门证
     * @param applyVO
     * @return
     */
    @RequestMapping(value = "/api/apply/push", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<ApplyVO> push(@RequestBody ApplyVO applyVO);

}
